<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Ionize CMS
 *
 * Image Library
 * 
 * Extends the CodeIgniter CI_Image_lib by adding : 
 * - Some memory check before picture creation, to avoid fatal errors
 * - An unsharp library
 *
 * @package		Ionize
 * @category	Libraries
 * @author		Ionize Dev Team
 * @license		http://doc.ionizecms.com/en/basic-infos/license-agreement
 * @link		http://ionizecms.com
 * @since		Version 0.9.0
 *
 */

class MY_Input extends CI_Input {


	/**
	* Replace a $_POST entry by another value
	*
	* @access	public
	* @param	string		The index key
	* @param	string		The new value
	* @return	boolean		true if success
	*
	*/
	function set_post($index, $value)
	{
		if ( ! empty($index))
		{
			$_POST[$index] = $value;
			
			return true;
		}
		return false;
	}

	/* BLS
	 * read angular ajax post
	 */
	function ajax($index = NULL, $xss_clean = FALSE)
	{
		$_POST = (array) json_decode(file_get_contents('php://input'));
		
		// Check if a field has been provided
		if ($index === NULL AND ! empty($_POST))
		{
			$post = array();

			// Loop through the full _POST array and return it
			foreach (array_keys($_POST) as $key)
			{
				$post[$key] = $this->_fetch_from_array($_POST, $key, $xss_clean);
			}
			return $post;
		}
		
		return $this->_fetch_from_array($_POST, $index, $xss_clean);
	}


}
