<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ajaxform_module_model extends Base_model 
{
	protected $_table_user = 'module_ajaxform_user';
	protected $_table_configuratore = 'module_ajaxform_configuratore';
	protected $_table_contact = 'module_ajaxform_contact';
	
	protected $_structure_user = array(
		'id_user' => 0,
		'email' => NULL,
		'informativa' => 0,
		'nome' => NULL,
		'cognome' => NULL,
		'attivita' => NULL,
		'telefono' => NULL,
		'cap' => NULL,
		'draft' => 1,
		'timestamp' => NULL
	);
	
	protected $_structure_configuratore = array(
		'id_user' => 0,
		'id_data' => 0,
		'banner' => NULL,
		'year' => NULL,
		'month' => NULL,
		'day' => NULL,
		'filter' => NULL,
		'position' => NULL,
		'background' => NULL,
		'progetto' => NULL,
		'hash' => NULL 
	);
	
	protected $_structure_contact = array(
		'id_user' => 0,
		'id_data' => 0,
		'categoria' => NULL,
		'progetto' => NULL,
		'provincia' => NULL,
		'messaggio' => NULL,
		'referenza' => NULL,
		'hash' => NULL
	);
	
	protected $id_user = 0;

	public function __construct()
	{
		parent::__construct();
		
		// discerno se post o ajax
		$form = $this->input->post('form');
		if(!empty($form)) {
			// it's post
			$this->data = $this->input->post();
		} else {
			// try ajax
			$this->data = $this->input->ajax();
		}
		
		$this->form = $this->data['form'];
	}		
	
	/*
	 * Aggiunge un utente vuoto
	 * 
	 * TODO: proteggere
	 */
	public function add_user() {
		
		// $data = $this->input->ajax('form');

		// creo un utente gestendo i soli dati della sua struttura
		$this->_structure_user['timestamp'] = time();
		$this->db->insert($this->_table_user,$this->_structure_user);
		//ottengo id_user
		$id_user = $this->db->insert_id();
		
		// giro l'id
		$this->{"_structure_$this->form"}['id_user'] = $id_user;
		$this->db->insert( $this->{"_table_$this->form"}, $this->{"_structure_$this->form"});
		
		if((int) $id_user > 0) {
			$this->id_user = $id_user;
		}
		
		return $id_user; 
	}
	
	public function save($data = array()) {
		$this->data = array_merge($this->data,$data);
		
		// set hash
		$this->data['hash'] = md5($this->data['id_user'] . $this->data['banner'] . $this->data['year'] . $this->data['month'] . $this->data['day'] . $this->data['email']);
		
		$data_user = array_intersect_key($this->data,$this->_structure_user); 
		$save_user = $this->save_user($data_user);
		
		
		$data_form = array_intersect_key($this->data,$this->{"_structure_$this->form"});

		// save
		$save_form = $this->save_form($data_form);
		
		if($save_user && $save_form) return $this->data;
		return false;
	}
	
	public function save_user($data) {
		
		if($this->db
		->where('id_user',$data['id_user'])
		->update($this->_table_user,$data))
		{
			return $data['id_user'];
		} else {
			return false;
		}
	}
	
	public function save_form($data) {
		if($this->db
		->where('id_user',$data['id_user'])
		->update($this->{"_table_$this->form"},$data))
		{
			return $data['id_user'];
		} else {
			return false;
		}
	}
}