<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Template_model extends Base_model 
{
	public function __construct()
	{
		parent::__construct();
	}
	
	/*
	 * Dato un path restituisce il contenuto di quel template
	 */
	public function get_raw_template($path) {
		$raw_html = $this->load->file($path,true);
		
		// strippo script
		$html = preg_replace('#<script(.*?)>(.*?)</script>#is', '', $raw_html);
		
		return $html;
	}

	/*
	 * Dato un percorso restituisce l'elenco flat di percorsi ai file
	 */	
	public function get_list($path) {
		$this->load->helper('directory');

		$template_array = dirToArray($path);
		
		$template_list = $this->recursive_array_path_to_list($template_array,$path);
		
		return $template_list;
	}
	
	/*
	 * Ricorre dentro un array dir/dir/file e restituisce una lista flat di percorsi
	 */
	private function recursive_array_path_to_list($array,$pre)
	{
		unset($list);
		
		if(empty($array)) return false;
		
		foreach($array as $key => $value) {
			
			if(is_array($value)) {
				$_list = $this->recursive_array_path_to_list($value, $pre . $key . '/');
				$list = $_list ? array_merge($list,$_list) : $list;
			}
			else {
				$list[] = $pre . $value;
			}
			
		}
		
		return $list;
	}
}
