<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Province extends Module_Admin
{
    /**
     * Constructor
     *
     * @access  public
     * @return  void
     */
    public function construct()
    {
        // Loads the model as 'author_model'
        $this->load->model('province_prodotti_model', 'prodotti_model', true);
    }
	
	public function index() {
		$this->get_list();
	}
 
    /**
     * Outputs the authors list
     *
     */
    public function get_list()
    {
        $conds = array(
            'order_by' => 'regione_name ASC'
        );
		
		$_prodotti = $this->prodotti_model->get_list($conds);
		foreach($_prodotti as $_prodotto) {
			$regione = $_prodotto['regione_name'];
			$provincia = $_prodotto['provincia'];
			
			$prodotti[$regione][$provincia] = $_prodotto;
		}
		
		// estraggo le chiavi
		foreach($_prodotto as $chiavi => $_null) {
			$this->template['chiavi'][] = $chiavi;	
		}
 
        $this->template['prodotti'] = $prodotti;
 
        $this->output('admin/prodotti_list');
    }
 
    /**
     * Outputs the detail of one author
     * @param  int    ID of the author
     *
     */
    public function get($id)
    {
        /* has to be written */
    }
 
    /**
     * Saves one author
     *
     */
    public function save()
    {
		// Model used to write config.php
		$this->load->model('config_model', '', TRUE);
		
		// Settings to save
		$settings = array(
			'id_provincia',
			'targa',
			'provincia',
			'cestino',
			'indicatore',
			'orologio',
			'palina',
			'pensilina',
			'stendardo',
			'transenna',
			'mediapole'
		);

		// normalize
		foreach($settings as $field)
		{
			$prodotti = $this->input->post($field);
			
			foreach($prodotti as $id => $el) {
				if($id>0) {
					
					// integer
					if(
						$field == 'cestino' || 
						$field == 'indicatore' || 
						$field == 'orologio' ||
						$field == 'palina' || 
						$field == 'pensilina' || 
						$field == 'stendardo' ||
						$field == 'transenna' ||
						$field == 'mediapole'
					) $el = (int) $el;
					// string
					else $el = trim($el);
					
					// update array
					$update[$id][$field] = $el;
				}
			}
		}
		
		// save
		foreach($update as $key => $data) {
			$this->db->where('id_provincia', $key);
			$salvataggio = $this->db->update('module_province_prodotti', $data);
			
			if(!$salvataggio) {
				$this->error('Errore durante il salvataggio: verificare i dati.');
				log_message('error', $field . ':' . $setting);
				
				die();				
			} 
		}

		//reload dashboard
		$this->callback[] = array(
			'fn' => 'ION.updateElement',
			'args' => array(
				'element' => 'mainPanel',
				'url' => 'module/province/province/index'
			)
		);
		$this->callback[] = array(
			'fn' => 'ION.updateElement',
			'args' => array(
				'element' => 'structurePanel',
				'url' => 'tree'
			)
		);

		// Answer
		$this->success(lang('ionize_message_operation_ok'));

    }
}