<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Rendering extends My_Module {
	
	public function __construct() {
		parent::__construct();

		ini_set('memory_limit', '8192M' );
		
		// init data
		$this->init_default();
		$this->init_config();
	}

	function index($method) {
		$uri = $this->uri->uri_string();

		$uri = str_replace("rendering/".$method."/", "", $uri);
		
		$params = explode("/", $uri);
		if(isset($method)) {
			if(method_exists($this, $method)) {
				if(count($params) > 0) {

					//$this->$method($params);
					call_user_func_array(array($this, $method), $params);

				} else {

					$this->$method($uri);
				}
			}
		}
	}
	
	private function init_default() {
		// POSITIONS
		$this->default['positions'] = array(
			'MIDDLE','TOP','BOTTOM','FILL','PATTERN'
		);
		
		// COMPOSITIONS
		$this->default['compositions'] = array(
			'COMPOSITE_DEFAULT',
			'COMPOSITE_UNDEFINED',
			'COMPOSITE_NO',
			'COMPOSITE_ADD',
			'COMPOSITE_ATOP',
			'COMPOSITE_BLEND',
			'COMPOSITE_BUMPMAP',
			'COMPOSITE_CLEAR',
			'COMPOSITE_COLORBURN',
			'COMPOSITE_COLORDODGE',
			'COMPOSITE_COLORIZE',
			'COMPOSITE_COPYBLACK',
			'COMPOSITE_COPYBLUE',
			'COMPOSITE_COPY',
			'COMPOSITE_COPYCYAN',
			'COMPOSITE_COPYGREEN',
			'COMPOSITE_COPYMAGENTA',
			'COMPOSITE_COPYOPACITY',
			'COMPOSITE_COPYRED',
			'COMPOSITE_COPYYELLOW',
			'COMPOSITE_DARKEN',
			'COMPOSITE_DSTATOP',
			'COMPOSITE_DST',
			'COMPOSITE_DSTIN',
			'COMPOSITE_DSTOUT',
			'COMPOSITE_DSTOVER',
			'COMPOSITE_DIFFERENCE',
			'COMPOSITE_DISPLACE',
			'COMPOSITE_DISSOLVE',
			'COMPOSITE_EXCLUSION',
			'COMPOSITE_HARDLIGHT',
			'COMPOSITE_HUE',
			'COMPOSITE_IN',
			'COMPOSITE_LIGHTEN',
			'COMPOSITE_LUMINIZE',
			'COMPOSITE_MINUS',
			'COMPOSITE_MODULATE',
			'COMPOSITE_MULTIPLY',
			'COMPOSITE_OUT',
			'COMPOSITE_OVER',
			'COMPOSITE_OVERLAY',
			'COMPOSITE_PLUS',
			'COMPOSITE_REPLACE',
			'COMPOSITE_SATURATE',
			'COMPOSITE_SCREEN',
			'COMPOSITE_SOFTLIGHT',
			'COMPOSITE_SRCATOP',
			'COMPOSITE_SRC',
			'COMPOSITE_SRCIN',
			'COMPOSITE_SRCOUT',
			'COMPOSITE_SRCOVER',
			'COMPOSITE_SUBTRACT',
			'COMPOSITE_THRESHOLD',
			'COMPOSITE_XOR'
		);
		
		// FILTERS
		$this->default['filters'] = array(
			'NONE',
			'COLORIZE',
			'BLUR',
			'CONTRAST'
		);
		
		// FONTS
		$this->default['fonts'] = array(
			'NONE',
			'ARIAL',
			'IMPACT',
			'TIMES'
		);
	}

	private function get_default_config() {
		// palina
		$this->configuration['palina'] = array(
			'dir'	=>	'files_configuratore',
			'year'	=>	'../default',
			'month'	=>	'.',
			'day'	=>	'.',
			'master'	=>	'palina',
			'shader'	=>	'glass',
			'banner'	=>	'avipitalia.jpg',
			'color' => 'ffffff',
			'background' => 'ffffff',
			'filter' => 'NONE',
			'position' => 'MIDDLE',
			'quality'	=> '80',
			'width'		=> '800',
			'height'	=> '800',
			'hash' => FALSE,
			'font' => 'NONE',

			'ax'	=> 326,
			'ay'	=> 127,
			'bx'	=> 572,
			'by'	=> 144,
			'cx'	=> 578,
			'cy'	=> 490,
			'dx'	=> 331,
			'dy'	=> 484
		);
		
		// pensilina
		$this->configuration['pensilina'] = array(
			'dir'	=>	'files_configuratore',
			'year'	=>	'../default',
			'month'	=>	'.',
			'day'	=>	'.',
			'master'	=>	'pensilina',
			'shader'	=>	'glass',
			'banner'	=>	'avipitalia.jpg',
			'color' => 'ffffff',
			'background' => 'ffffff',
			'filter' => 'NONE',
			'position' => 'MIDDLE',
			'quality'	=> '80',
			'width'		=> '800',
			'height'	=> '800',
			'hash' => FALSE,
			'font' => 'NONE',
			
			'ax'	=> 1044,
			'ay'	=> 401,
			'bx'	=> 1270,
			'by'	=> 395,
			'cx'	=> 1273,
			'cy'	=> 760,
			'dx'	=> 1047,
			'dy'	=> 755
		);
		
		// cavalcavia
		$this->configuration['cavalcavia'] = array(
			'dir'	=>	'files_configuratore',
			'year'	=>	'../default',
			'month'	=>	'.',
			'day'	=>	'.',
			'master'	=>	'cavalcavia',
			'shader'	=>	'cars',
			'banner'	=>	'avipitalia.jpg',
			'color' => 'ffffff',
			'background' => 'ffffff',
			'filter' => 'NONE',
			'position' => 'MIDDLE',
			'quality'	=> '80',
			'width'		=> '800',
			'height'	=> '800',
			'hash' => FALSE,
			'font' => 'NONE',
			
			'ax'	=> 30,
			'ay'	=> 315,
			'bx'	=> 1645,
			'by'	=> 328,
			'cx'	=> 1648,
			'cy'	=> 532,
			'dx'	=> 30,
			'dy'	=> 526
		);
		
		// cartello
		$this->configuration['cartello'] = array(
			'dir'	=>	'files_configuratore',
			'year'	=>	'../default',
			'month'	=>	'.',
			'day'	=>	'.',
			'master'	=>	'cartello',
			'shader'	=>	'cars',
			'banner'	=>	'avipitalia.jpg',
			'color' => 'ffffff',
			'background' => 'ffffff',
			'filter' => 'NONE',
			'position' => 'MIDDLE',
			'quality'	=> '80',
			'width'		=> '800',
			'height'	=> '800',
			'hash' => FALSE,
			'font' => 'NONE',
			
			'ax'	=> 784,
			'ay'	=> 187,
			'bx'	=> 1550,
			'by'	=> 186,
			'cx'	=> 1549,
			'cy'	=> 804,
			'dx'	=> 784,
			'dy'	=> 804
		);
		
		// default config
		$params = $this->uri->uri_to_assoc();
		
		if(!isset($params['config'])) $params['config'] = 'cartello'; // TODO?!?!?!?
		
		$this->settings = $this->configuration["{$params['config']}"]; // TODO config di base
		$this->settings['hash'] = $params['hash'];
		
	}

	private function get_uri_config() {
		// VERIFICO IL CONFIG DA ADOTTARE
		$params = $this->uri->uri_to_assoc();
		
		// se c'è attività unsetto (non settabile da uri)
		unset($params['attivita']);
		
		if(isset($params['config']) && isset($this->configuration["{$params['config']}"])) {
			$this->settings = $this->configuration["{$params['config']}"];
		}
		else {
			$this->settings = $this->configuration['palina'];			
		}
		
		// INHERIT		
		// inherit: sostituisco i parametri passati a quelli default
		foreach($params as $key => $value) {
			if(!empty($value) && isset($this->settings[$key]))
				$this->settings[$key] = $value;
		}
	}
	
	private function get_hash_config() {
		// ottengo i dati da hash
		
		if($this->settings['hash'] != '') {
			$this->db->join('module_ajaxform_user','module_ajaxform_configuratore.id_user = module_ajaxform_user.id_user','LEFT');
			$this->db->where('hash',$this->settings['hash']);
			$_result = $this->db->get('module_ajaxform_configuratore');
			$result = $_result->result_array();
			
			$this->hashdata = $result[0]; // salvo qui i dati estratti da db
		
			// esco in caso di errori
			if(count($result) > 0)
			{
				if(isset($this->hashdata['config']) && isset($this->configuration["{($this->hashdata['config']}"])) {
					$this->settings = $this->configuration["{$this->hashdata['config']}"];
				}
				else {
					$this->settings = $this->configuration['palina'];			
				}
				
				
				foreach($result[0] as $key => $value) {
					if(!empty($value) && isset($this->settings[$key]))
						$this->settings[$key] = $value;
				}
			}
			
		} // end hash
	}
	
	private function normalize_config() {
		// COLOR AND BACKGROUND
		$this->settings['background'] = '#' . $this->settings['background'];
		$this->settings['color'] = '#' . $this->settings['color'];
		
		if(!preg_match('/^#[a-f0-9]{6}$/i', $this->settings['background'])) { //hex color is valid
			$this->settings['background'] = '#ffffff';
		}
		if(!preg_match('/^#[a-f0-9]{6}$/i', $this->settings['color'])) { //hex color is valid
			$this->settings['color'] = '#ffffff';
		}
		
		
		// FILTER
		if(!in_array($this->settings['filter'],$this->default['filters'])) $this->settings['filter'] = 'NONE';
	}

	/*
	 * Init floor configuration
	 */
	private function init_config() {
			
		// get config
		$this->get_default_config();
		$this->get_hash_config();
		$this->get_uri_config();
		
		// normalize
		$this->normalize_config();
	}


	/*
	 * DISPLAY IMAGE
	 */
	public function display()
	{
		// PATH
		$this->master['file'] = $this->settings['dir'] . '/masters/' . $this->settings['master'] . '.png';
		$this->shader['file'] = $this->settings['dir'] . '/shaders/' . $this->settings['shader'] . '.png';
		$this->banner['file'] = $this->settings['dir'] . '/uploads/' . $this->settings['year'] . '/' . $this->settings['month'] . '/' . $this->settings['day'] . '/' . $this->settings['banner'];

		// BANNER
		$this->banner['im'] = new Imagick(FCPATH . $this->banner['file']);
		$this->banner['im']->setImageVirtualPixelMethod(Imagick::VIRTUALPIXELMETHOD_TRANSPARENT);
		
		// MEASURES
		$this->calculate_measures();		

		// PASSPARTOUT
		$this->passpartout['im'] = new \Imagick();
		// il passpartout ha come sfondo il background
		$this->passpartout['im']->newImage($this->passpartout['w'], $this->passpartout['h'], $this->settings['background']); // il colore arriva hex senza # (per supportare url e hashbang)
		
		
		
		
		// NORMALIZZAZIONE DEL BANNER RISPETTO A HOLE
		$this->normalize_ratio();
		
		// MAKE FILTER
		$this->make_filter();
		
		// MAKE TEXT
		$this->make_text();

		// MAKE POSITION		
		$this->make_position();

		// MAKE PERSPECTIVE
		$this->make_banner_perspective();
		$this->make_text_perspective();

		// MASTER
		$this->master['im'] = new Imagick(FCPATH . $this->master['file']);
		$this->master['im']->setImageVirtualPixelMethod(Imagick::VIRTUALPIXELMETHOD_TRANSPARENT);
		
		// MAKE SHADER
		$this->shader = $this->make_shader($this->shader);
		
		// COMPOSITION
		$this->make_composition();

		// OUTPUT
		$this->make_output();
	}

	private function make_output() {
			// compression
			$this->outputimage['im']->setImageCompression(Imagick::COMPRESSION_JPEG); 
			$this->outputimage['im']->setImageCompressionQuality( max((int) $this->settings['quality'],1) ); // non meno di 1 per la qualità 
			$this->outputimage['im']->stripImage();
			
	
	
			// DISPLAY IMAGE
			header('Content-Type: image/jpg');
			$image = $this->outputimage['im']->getImageBlob();
			echo $image;
			//var_dump($this->settings);
	
	
			
			// CLEAR MEMORY
			$this->outputimage['im']->clear();
	}
	
	private function calculate_measures() {
		// master (hole) measures
		$this->master['hole']['w'] = $this->settings['bx'] - $this->settings['ax'];
		$this->master['hole']['h'] = $this->settings['by'] - $this->settings['ay'];
		
		// banner measures
		$this->banner['w'] = $this->banner['im']->getImageWidth();
		$this->banner['h'] = $this->banner['im']->getImageHeight();
		
 		// lati orizzontali 		
 		$this->master['lati']['ab'] = sqrt(pow(($this->settings['bx'] - $this->settings['ax']),2) + pow(($this->settings['by'] - $this->settings['ay']),2));
		$this->master['lati']['cd'] = sqrt(pow(($this->settings['cx'] - $this->settings['dx']),2) + pow(($this->settings['cy'] - $this->settings['dy']),2));
		
		// lati verticali
		$this->master['lati']['bc'] = sqrt(pow(($this->settings['cx'] - $this->settings['bx']),2) + pow(($this->settings['cy'] - $this->settings['by']),2));
		$this->master['lati']['da'] = sqrt(pow(($this->settings['dx'] - $this->settings['ax']),2) + pow(($this->settings['dy'] - $this->settings['ay']),2));
		
		// lati lunghi
		$this->master['lati']['orizzontale'] = max($this->master['lati']['ab'],$this->master['lati']['cd']);
		$this->master['lati']['verticale'] = max($this->master['lati']['bc'],$this->master['lati']['da']);

		// medie
		$lati['media_orizzontale'] = round(($this->master['lati']['ab'] + $this->master['lati']['cd'])/2);
 		$lati['media_verticale'] = round(($this->master['lati']['bc'] + $this->master['lati']['da'])/2);
		
		// passpartout
		$this->passpartout['w'] = $lati['media_orizzontale'];
		$this->passpartout['h'] = $lati['media_verticale'];
		
 		$this->master['ratio'] = round($lati['media_orizzontale']/$lati['media_verticale'],2);
		$this->banner['ratio'] = round($this->banner['w']/$this->banner['h'],2);
	}

	private function make_composition() {
		// OUTPUT
		$this->outputimage['im'] = new Imagick();
		$this->outputimage['im']->newImage($this->master['im']->getImageWidth(), $this->master['im']->getImageHeight(), new ImagickPixel('white'));
		$this->outputimage['im']->setImageFormat('jpg');
	
		// master
		$this->outputimage['im']->compositeImage($this->master['im'], Imagick::COMPOSITE_OVER, 0,0);
		$this->master['im']->clear();
		
		// passpartout
		$this->outputimage['im']->compositeImage($this->passpartout['im'], Imagick::COMPOSITE_OVER, $this->settings['ax'],$this->settings['ay']);
		$this->passpartout['im']->clear();
		
		// TEXT
		if(isset($this->text['im'])) {
			$this->outputimage['im']->compositeImage($this->text['im'], Imagick::COMPOSITE_OVER, $this->settings['ax'],$this->settings['ay']);
			// $this->text['im']->clear();	
		}
		
		// SHADER
		$this->outputimage['im']->compositeImage($this->shader['im'], Imagick::COMPOSITE_OVER, $this->settings['ax'],$this->settings['ay']);
		$this->shader['im']->clear();
		
		// LAST RESIZE
		$this->outputimage['im']->scaleImage(max((int) $this->settings['width'],1), max((int) $this->settings['height'],1), true);
	}

	private function normalize_ratio() {
		// se la ratio è simile procedo (0.x) senza intervenire sulla prospettiva
		$r = abs($this->master['ratio'] - $this->banner['ratio']);
		if($this->settings['position']=='FILL') { // se non è FILL
		// if($r > .2 && $this->settings['position']!='FILL') { // se l'immagine diverge di oltre .2 la ridimensiono normalmente
			// fill no ha padding
			$this->padding = 0;
			$this->banner['nw'] = $this->passpartout['w'];
			$this->banner['nh'] = $this->passpartout['h'];
		} else {	// se l'immagine diverge meno di .2 oppure forzo FILL la stiro (FILL)
			// IMMAGINE DIVERSA
			// applico un padding pari a 1/xx del passpartout
			$this->paddingPercent = 40; // 1/40 della larghezza o della altezza del passpartout. Prene il valore più piccolo.
			$this->padding = min(round($this->passpartout['w']/$this->paddingPercent),round($this->passpartout['h']/$this->paddingPercent));
			
			// Calcolo la scala e applico il padding
			$scale = min($this->passpartout['w']/$this->banner['w'], $this->passpartout['h']/$this->banner['h']);
			$this->banner['nw'] = round($scale * $this->banner['w']) - ($this->padding*2);
			$this->banner['nh'] = round($scale * $this->banner['h']) - ($this->padding*2);
		}
	}

	private function make_filter() {
		// APPLICO EVENTUALI FILTRI A BANNER
		// constant('Imagick::' . $this->settings['composition'])
		switch($this->settings['filter']) {
			case 'CONTRAST':
				$this->banner['im']->contrastImage(1);
				$this->banner['im']->contrastImage(1);
				break;
			case 'COLORIZE':
				$this->banner['im']->colorizeImage($this->settings['background'], 0.35);
				break;
			case 'BLUR':
				// $this->banner['im']->radialBlurImage(7);
				// $this->banner['im']->radialBlurImage(3);
				$this->banner['im']->radialBlurImage(1);
				$this->banner['im']->blurImage(10,10,imagick::CHANNEL_DEFAULT);
				
				break;
			case 'NONE':
			default:
				break;	
		}
	}

	private function make_banner_perspective() {
		// BANNER PERSPECTIVE
		// banner: Control points for the distortion (PERSPECTIVE)
		$controlPointsPerspectiveBanner = array(
						        0,0, $this->settings['ax'],$this->settings['ay'], # top left 
						        $this->passpartout['w'],0, $this->settings['bx'],$this->settings['by'], # top right
						        $this->passpartout['w'],$this->passpartout['h'], $this->settings['cx'],$this->settings['cy'], # bottom right
						        0,$this->passpartout['h'], $this->settings['dx'],$this->settings['dy'] # bottom left
							);
		// banner: Perform the distortion                       
		$this->passpartout['im']->setImageVirtualPixelMethod( \Imagick::VIRTUALPIXELMETHOD_TRANSPARENT);
		$this->passpartout['im']->distortImage(\Imagick::DISTORTION_PERSPECTIVE, $controlPointsPerspectiveBanner, true);
	}

	private function make_text_perspective() {
		if(isset($this->text['im'])) {
			
			// TEXT PERSPECTIVE
			// banner: Control points for the distortion (PERSPECTIVE)
			$controlPointsPerspectiveText = array(
							        0,0, $this->settings['ax'],$this->settings['ay'], # top left 
							        $this->passpartout['w'],0, $this->settings['bx'],$this->settings['by'], # top right
							        $this->passpartout['w'],$this->passpartout['h'], $this->settings['cx'],$this->settings['cy'], # bottom right
							        0,$this->passpartout['h'], $this->settings['dx'],$this->settings['dy'] # bottom left
								);
			// banner: Perform the distortion                       
			$this->text['im']->setImageVirtualPixelMethod( \Imagick::VIRTUALPIXELMETHOD_TRANSPARENT);
			$this->text['im']->distortImage(\Imagick::DISTORTION_PERSPECTIVE, $controlPointsPerspectiveText, true);
		}
	}

	private function make_position() {
		// utilizzando il position
		// determino il posizionamento di partenza del banner da disporre
		switch($this->settings['position']) {
			case 'TOP':
				// RIDIMENSIONO BANNER
				// modifico larghezza o altezza max e ridimensiono compensando con bestfit
				$this->banner['nw']-=max($this->padding*5,20); // prevengo che la nuova dimensione sia inferiore a un minimo (20)
				$this->banner['im']->adaptiveResizeImage($this->banner['nw'], $this->banner['nh'], true);
				$this->banner['nw'] = $this->banner['im']->getImageWidth(); // ricalcolo
				$this->banner['nh'] = $this->banner['im']->getImageHeight(); // ricalcolo
				
				// top centrato
				$dispose['x'] = round($this->passpartout['w']/2 - $this->banner['nw']/2);
				$dispose['y'] = 0 + $this->padding;
				$this->passpartout['im']->compositeImage(
					$this->banner['im'],
					Imagick::COMPOSITE_OVER,
					$dispose['x'],
					$dispose['y']
				);
				break;
			case 'RIGHT':
				// RIDIMENSIONO BANNER
				// modifico larghezza o altezza max e ridimensiono compensando con bestfit
				$this->banner['nh']-=max($this->padding*5,20); // prevengo che la nuova dimensione sia inferiore a un minimo (20)
				$this->banner['im']->adaptiveResizeImage($this->banner['nw'], $this->banner['nh'], true);
				$this->banner['nw'] = $this->banner['im']->getImageWidth(); // ricalcolo
				$this->banner['nh'] = $this->banner['im']->getImageHeight(); // ricalcolo
				
				// middle right
				$dispose['x'] = $this->passpartout['w'] - $this->banner['nw'] - $this->padding;
				$dispose['y'] = round($this->passpartout['h']/2 - $this->banner['nh']/2);
				$this->passpartout['im']->compositeImage(
					$this->banner['im'],
					Imagick::COMPOSITE_OVER,
					$dispose['x'],
					$dispose['y']
				);
				break;
			case 'BOTTOM':
				// RIDIMENSIONO BANNER
				// modifico larghezza o altezza max e ridimensiono compensando con bestfit
				$this->banner['nw']-=max($this->padding*5,20); // prevengo che la nuova dimensione sia inferiore a un minimo (20)
				$this->banner['im']->adaptiveResizeImage($this->banner['nw'], $this->banner['nh'], true);
				$this->banner['nw'] = $this->banner['im']->getImageWidth(); // ricalcolo
				$this->banner['nh'] = $this->banner['im']->getImageHeight(); // ricalcolo
				
				// centrato bottom
				$dispose['x'] = round($this->passpartout['w']/2 - $this->banner['nw']/2);
				$dispose['y'] = $this->passpartout['h'] - $this->banner['nh'] - $this->padding;
				$this->passpartout['im']->compositeImage(
					$this->banner['im'],
					Imagick::COMPOSITE_OVER,
					$dispose['x'],
					$dispose['y']
				);
				break;
			case 'LEFT':
				// RIDIMENSIONO BANNER
				// limando un po' di dimensione WIDTH per accentuare il LEFT con bestfit
				$this->banner['nh']-=max($this->padding*5,20); // prevengo che la nuova dimensione sia inferiore a un minimo (20)
				$this->banner['im']->adaptiveResizeImage($this->banner['nw'], $this->banner['nh'], true);
				$this->banner['nw'] = $this->banner['im']->getImageWidth(); // ricalcolo
				$this->banner['nh'] = $this->banner['im']->getImageHeight(); // ricalcolo
				
				// middle left
				$dispose['x'] = $this->padding;
				$dispose['y'] = round($this->passpartout['h']/2 - $this->banner['nh']/2);
				$this->passpartout['im']->compositeImage(
					$this->banner['im'],
					Imagick::COMPOSITE_OVER,
					$dispose['x'],
					$dispose['y']
				);
				break;
			case 'PATTERN':
				// RIDIMENSIONO BANNER
				$this->banner['im']->adaptiveResizeImage($this->banner['nw'], $this->banner['nh']);
				
				// per ogni colonna
				for($ix=-$this->banner['nw'];$ix<$this->passpartout['w'];$ix+=$this->banner['nw']+$this->padding) {
					// per ogni riga
					for($iy=-$this->banner['nh'];$iy<$this->passpartout['h'];$iy+=$this->banner['nh']+$this->padding) {
						// effettuo il posizionamento
						$this->passpartout['im']->compositeImage(
							$this->banner['im'],
							Imagick::COMPOSITE_OVER,
							$ix,
							$iy
						);
					}
				}

				break;
			case 'FILL':
			case 'MIDDLE':
			default:
				// RIDIMENSIONO BANNER
				$this->banner['im']->adaptiveResizeImage($this->banner['nw'], $this->banner['nh']);
				
				// centrato centrato
				$dispose['x'] = round($this->passpartout['w']/2 - $this->banner['nw']/2);
				$dispose['y'] = round($this->passpartout['h']/2 - $this->banner['nh']/2);
				$this->passpartout['im']->compositeImage(
					$this->banner['im'],
					Imagick::COMPOSITE_OVER,
					$dispose['x'],
					$dispose['y']
				);
				break;
		}
		

		// banner memory
		// $this->banner['im']->clear();
	}

	private function make_shader() {
		$this->shader['im'] = new Imagick(FCPATH . $this->shader['file']);
		$this->shader['im']->setImageVirtualPixelMethod(Imagick::VIRTUALPIXELMETHOD_TRANSPARENT);
		
		// shader measures
		$this->shader['w'] = $this->shader['im']->getImageWidth();
		$this->shader['h'] = $this->shader['im']->getImageHeight();

		
		
		
		
		
		// SHADER PERSPECTIVE
		// banner: Control points for the distortion (PERSPECTIVE)
		$controlPointsPerspectiveShader = array(
						        0,0, $this->settings['ax'],$this->settings['ay'], # top left 
						        $this->shader['w'],0, $this->settings['bx'],$this->settings['by'], # top right
						        $this->shader['w'],$this->shader['h'], $this->settings['cx'],$this->settings['cy'], # bottom right
						        0,$this->shader['h'], $this->settings['dx'],$this->settings['dy'] # bottom left
							);
		// banner: Perform the distortion
		$this->shader['im']->setImageVirtualPixelMethod( \Imagick::VIRTUALPIXELMETHOD_TRANSPARENT);                    
		$this->shader['im']->distortImage(Imagick::DISTORTION_PERSPECTIVE, $controlPointsPerspectiveShader, true);
		
		return $this->shader;
	}

	private function make_text() {
		if($this->settings['font'] && $this->settings['font']!='NONE') {
			// creo l'immagine testo
			$this->text['im'] = new Imagick();

			if(isset($this->hashdata) && isset($this->hashdata['attivita'])) {
				$this->text['caption'] = 	$this->hashdata['attivita'];
			} else {
				$this->text['caption'] = ' ';
			}
			
			// caratteristiche testo
			$draw = new ImagickDraw();
			
			switch($this->settings['font']) {
				case 'VARSITY':
					// font
					$this->text['size'] = 100;
					$this->text['lineheightdelta'] = 0;
					$draw->setFont('modules/Rendering/assets/fonts/varsity.ttf');
					break;
				case 'SUNRISE':
					// font
					$this->text['size'] = 100;
					$this->text['lineheightdelta'] = 0;
					$draw->setFont('modules/Rendering/assets/fonts/sunrise.ttf');
					break;
				case 'ACTION':
					$this->text['size'] = 100;
					$this->text['lineheightdelta'] = -7;
					$draw->setFont('modules/Rendering/assets/fonts/action.ttf');
					break;
				case 'KEEPCALM':
					$this->text['size'] = 100;
					$this->text['lineheightdelta'] = 0;
					$draw->setFont('modules/Rendering/assets/fonts/keepcalm.ttf');
					// testo maiuscolo
					$this->text['caption'] = strtoupper($this->text['caption']);
					break;
				case 'VIAFONT':
					$this->text['size'] = 100;
					$this->text['lineheightdelta'] = -10;
					$draw->setFont('modules/Rendering/assets/fonts/viafont.ttf');
					break;
				case 'ACNE':
					$this->text['size'] = 100;
					$this->text['lineheightdelta'] = 0;
					$draw->setFont('modules/Rendering/assets/fonts/radicalblock.ttf');
					break;
				case 'PRISMA':
					$this->text['size'] = 100;
					$this->text['lineheightdelta'] = 0;
					$draw->setFont('modules/Rendering/assets/fonts/prisma.ttf');
					break;
				case 'TYPEWRITER':
					$this->text['size'] = 100;
					$this->text['lineheightdelta'] = 0;
					$draw->setFont('modules/Rendering/assets/fonts/typewriter.ttf');
					break;
				case 'NONE':
				default:
					break;	
			}
			
			$this->text['im']->newImage ($this->passpartout['w'],$this->passpartout['h'], "none");
			$draw->setGravity (Imagick::GRAVITY_CENTER);
			$draw->setFillColor($this->settings['color']);
			$draw->settextantialias(true);
			
			$fontSize = $this->text['size'];
			
			// se la proporzione orizzontale è forte (ad es. cavalcavia) allora non splitto ma uso regola diversa
			if($this->passpartout['h']*2 <  $this->passpartout['w']) {

				// se il testo è troppo piccolo lo ingrandisco
				do {
					$fontSize+=1;
					$draw->setFontSize( $fontSize );
					$metrics = $this->text['im']->queryFontMetrics($draw, $this->text['caption']);
					
				} while($metrics['textWidth']<=$this->passpartout['w']);
				
				// se il testo è troppo grande lo rimpicciolisco
				do {
					$fontSize-=1;
					$draw->setFontSize( $fontSize );
					$metrics = $this->text['im']->queryFontMetrics($draw, $this->text['caption']);
					
				} while($metrics['textWidth']>$this->passpartout['w']);

				$fontSize-=2;
				$draw->setFontSize( $fontSize );
				$this->text['im']->annotateImage($draw, 0, 0, 0, $this->text['caption']);

			} else {

				// altrimenti splitto e metto una parola per riga
				$words = explode(' ',$this->text['caption']);
				$maxWidth = 0;
				foreach($words as $i => $word)
				{
					// per ogni parola trovo dimensioni
					$metrics = $this->text['im']->queryFontMetrics($draw, $this->text['caption']);
					$maxWidth = max($metrics['textWidth'],$maxWidth);
					$lineHeight = $metrics['textHeight'];
					
					// calcolo il font size scendendo
					do {
						$fontSize--;
						$draw->setFontSize( $fontSize );
						$metrics = $this->text['im']->queryFontMetrics($draw, $word);
					} while($this->passpartout['w']<$metrics['textWidth']);
					
					// riduco ancora un po'
					$fontSize-=2;
					$draw->setFontSize( $fontSize );
					
					// Scrivo
					$this->text['im']->annotateImage($draw, 0, ($i-1)*$fontSize, 0, $word);
				}
			}

			
			// $draw->setTextAlignment (Imagick::ALIGN_LEFT);
			$this->text['im']->adaptiveResizeImage($this->passpartout['w'],$this->passpartout['h'],true);
			// $draw->clear();
		}
	}


	/*
	 * DISPLAY PDF
	 */
	public function pdf() {
		// require lib		(FPDF->)
		require_once MODPATH.'Rendering/libraries/fpdf17/fpdf.php';
		require_once MODPATH.'Rendering/libraries/fpdi154/fpdi.php';
		
		// ottengo i dati da hash
		if($this->settings['hash'] != '') {
			$this->db->join('module_ajaxform_user','module_ajaxform_configuratore.id_user = module_ajaxform_user.id_user','LEFT');
			$this->db->where('hash',$this->settings['hash']);
			$_result = $this->db->get('module_ajaxform_configuratore');
			$result = $_result->result_array();	

			// esco in caso di errori
			if(count($result)!=1) {
				// var_dump($result);
				header("HTTP/1.0 404 Not Found");
				echo "Document not found.";
				exit; // non ho risultat
			}
			else {
				// $this->settings['config'] = $result[0]['progetto'];
				
				foreach($result[0] as $key => $value) {
					if(!empty($value)) {
						if(isset($this->settings[$key])) {
							$this->settings[$key] = $value; // per l'immagine scarico i dati compatibili
						} else {
							$this->misc[$key] = $value; // gli altri dati li passo a questa proprietà per usarli nella stampa del pdf
						}
					}
				}
			}
		} // end hash
		
		$pdf = new FPDI();
		
		// dagli stessi parametri posso generare anche l'immagine

		// $image_url = base_url() . 'rendering/display'; // BLS OLD SERVER WELCOME ITALIA
		// echo $image_url;
		$image_url = 'http://192.168.68.162' . '/index.php/rendering/display'; // BLS CAMBIO SERVER OMITECH

		foreach($this->settings as $key => $value) {
				// se è attivita rimuovo da immagine
				if($key!='attivita')
			
				$image_url .= '/' . $key . '/' . $value;
		}
		
		// add a page
		$pdf->AddPage();

		// uso la carta intestata
		$pageCount = $pdf->setSourceFile(DOCPATH . 'files/pdf/coordinato/intestata.pdf');

		// import carta intestata A4
		$tplIdx = $pdf->importPage(1); // importo la prima pagina
		$pdf->useTemplate($tplIdx, 0, 0, 210); // 210 mm width A4, posizionata 0,0

		// font		
		$pdf->AddFont('opensans-semibold-webfont');
		$pdf->AddFont('opensans-regular-webfont');
		$pdf->AddFont('opensans-light-webfont');
		
		// destinatario
		$nome = $this->misc['nome'];
		$cognome = $this->misc['cognome'];
		$attivita = $this->misc['attivita'];
		$email = $this->misc['email'];
		$date = date('d/m/Y',$this->misc['timestamp']);
		
		// write
		$string = $date;
		$string .= "\n\n\n\n";
		$string .= 'Spett.le ' . $attivita;
		$string .= "\n\n\n\n";
		$string .= 'Att.ne ' . $nome . " " . $cognome;
		$string .= "\n\n";
		$string .= "e-mail: " . $email;
		$pdf->SetFont('opensans-light-webfont');
		$pdf->SetFontSize(10);
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetXY(15, 30);
		$pdf->SetTextColor(0, 0, 0);
		$string = utf8_decode($string);
	    $pdf->MultiCell(100,2,$string);
	    $pdf->Ln();
		
		// testo subject
		$pdf->SetFont('opensans-semibold-webfont');
		$pdf->SetFontSize(10);
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetXY(15, 65);
		$pdf->SetTextColor(0, 0, 0);
	    $pdf->MultiCell(180,2,'Oggetto: progetto di comunicazione per ' . $attivita);
	    $pdf->Ln();
		
		// testo body
		$pdf->SetFont('opensans-light-webfont');
		$pdf->SetFontSize(10);
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetXY(15, 70);
		$pdf->SetTextColor(0, 0, 0);
		$standard_text = "Un nostro consulente prenderà contatto con la sua azienda nei prossimi giorni per verificare assieme a lei il migliore progetto di comunicazione.";
	    $pdf->MultiCell(180,5,utf8_decode($standard_text));
	    $pdf->Ln();
		
		// testo subject
		$string = "Simulazione progetto";
		$string = strtoupper($string);
		$pdf->SetFont('opensans-light-webfont');
		$pdf->SetFontSize(8);
		$pdf->SetTextColor(0, 0, 0);
		$pdf->SetXY(15, 97);
		$pdf->SetTextColor(0, 0, 0);
	    $pdf->MultiCell(100,2,$string);
	    $pdf->Ln();
		
		// genero e stampo l'immagine
		$pdf->Image($image_url,15,100,180,0,'JPG');
		
		// echo $image_url; 
		
		$pdf->Output();
	}


}

