<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Theme Forms configuration
|--------------------------------------------------------------------------
|
| This forms config array will be merged with /application/config/forms.php
| You can overwrite standard forms definition by creating your own definition
| for the form you wish to overwrite.
|
*/
$config['forms'] = array
(
	// Contact form
	'configuratore' => array
	(
		'process' => 'TagManager_Contact::process_data',
		'redirect' => 'referer',
		'messages' => array(
			'success' => 'form_alert_error_message',
			'error' => 'form_alert_success_message',
		),
		'emails' => array
		(
			array
			(
				'email' => 'contact',
				'subject' => 'mail_website_contact_subject',
				'view' => 'mail/contact/to_admin',
			),
			array
			(
				'email' => 'form',
				'subject' => 'mail_user_contact_subject',
				'view' => 'mail/contact/to_user',
			),
		),
		'fields' => array
		(
			'attivita' => array
			(
				'rules' => 'trim|required|min_length[3]|xss_clean',
				'label' => 'form_label_attivita',
			),
			'file' => array
			(
				'label' => 'form_label_file',
			),
			'email' => array
			(
				'rules' => 'trim|email|xss_clean',
				'label' => 'form_label_email',
			),
		)
	),
	
	
	

	// Contact form
	'contact' => array
	(
		// The method which will process the form
		// The function name has no importance, it must only be in the declared Tagmanager class
		// and be "public static"
		'process' => 'TagManager_Contact::process_data',

		// Redirection after process. Can be 'home' or 'referer' for the $_SERVER['HTTP_REFERER'] value.
		// If not set, doesn't redirect
		'redirect' => 'preventivo-grazie',

		// Messages Language index, as set in language/xx/form_lang.php
		'messages' => array(
			'success' => 'form_alert_error_message',
			'error' => 'form_alert_success_message',
		),
		'emails' => array
		(
			// To Site Administrator
			array
			(
				// Send the mail to the address filled in in the 'email' input of the form
				// Values can be :
				// - One plain Email address : my.name@mydomain.com
				// - 'form' to send it to the email of the form data
				// - 'site' to send it to the Email set in Ionize under Settings > Advanced > Email > Website
				// - 'contact' to send it to the Email set in Ionize under Settings > Advanced > Email > Contact
				// - 'info' to send it to the Email set in Ionize under Settings > Advanced > Email > Info
				// - 'technical' to send it to the Email set in Ionize under Settings > Advanced > Email > Info
				'email' => 'contact',

				// Translation item index
				'subject' => 'mail_website_contact_subject',

				// Used view : Located in /themes/your_theme/mail/contact.php
				'view' => 'mail/contact/to_admin',
			),
			// Send to user
			array
			(
				'email' => 'form',
				'subject' => 'mail_user_contact_subject',
				'view' => 'mail/contact/to_user',
			),
		),
		// Form definition: fields and rules
		'fields' => array
		(
			'nome' => array
			(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_nome',
			),
			'cognome' => array
			(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_cognome',
			),
			'attivita' => array
			(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_attivita',
			),
			'categoria' => array
			(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_categoria',
			),
			'telefono' => array
			(
				'rules' => 'trim|required|numeric|xss_clean',
				'label' => 'form_label_telefono',
			),
			'email' => array(
				'rules' => 'trim|required|valid_email|xss_clean',
				'label' => 'form_label_email',
			),
			'provincia' => array
			(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_provincia',
			),
			'progetto' => array
			(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_progetto',
			),
            'informativa' => array(
                // Can be 'radio', 'checkbox', 'select' or not set for input and textarea
                'type' => 'checkbox',
                'rules' => 'required',
                'label' => 'form_label_heard_on',
            ),
			'messaggio' => array(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_messaggio',
			)
		)
	),


	// career form
	'career' => array
	(
		// The method which will process the form
		// The function name has no importance, it must only be in the declared Tagmanager class
		// and be "public static"
		'process' => 'TagManager_career::process_data',

		// Redirection after process. Can be 'home' or 'referer' for the $_SERVER['HTTP_REFERER'] value.
		// If not set, doesn't redirect
		'redirect' => 'candidatura-inviata',

		// Messages Language index, as set in language/xx/form_lang.php
		'messages' => array(
			'success' => 'form_alert_error_message',
			'error' => 'form_alert_success_message',
		),
		'emails' => array
		(
			// To Site Administrator
			array
			(
				// Send the mail to the address filled in in the 'email' input of the form
				// Values can be :
				// - One plain Email address : my.name@mydomain.com
				// - 'form' to send it to the email of the form data
				// - 'site' to send it to the Email set in Ionize under Settings > Advanced > Email > Website
				// - 'career' to send it to the Email set in Ionize under Settings > Advanced > Email > career
				// - 'info' to send it to the Email set in Ionize under Settings > Advanced > Email > Info
				// - 'technical' to send it to the Email set in Ionize under Settings > Advanced > Email > Info
				'email' => 'contact',

				// Translation item index
				'subject' => 'mail_website_contact_subject',

				// Used view : Located in /themes/your_theme/mail/career.php
				'view' => 'mail/career/to_admin',
			),
			// Send to user
			array
			(
				'email' => 'form',
				'subject' => 'mail_user_contact_subject',
				'view' => 'mail/career/to_user',
			),
		),
		// Form definition: fields and rules
		'fields' => array
		(
			'nome' => array
			(
				'rules' => 'trim|xss_clean',
				'label' => 'form_label_nome',
			),
			'fileupload' => array(
				'rules' => 'trim',
				'label' => 'form_label_file',
			),
			'cognome' => array
			(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_cognome',
			),
			'telefono' => array
			(
				'rules' => 'trim|required|numeric|xss_clean',
				'label' => 'form_label_telefono',
			),
			'email' => array(
				'rules' => 'trim|required|valid_email|xss_clean',
				'label' => 'form_label_email',
			),
            'informativa' => array(
                // Can be 'radio', 'checkbox', 'select' or not set for input and textarea
                'type' => 'checkbox',
                'rules' => 'required',
                'label' => 'form_label_heard_on',
            ),
            'informativa2' => array(
                // Can be 'radio', 'checkbox', 'select' or not set for input and textarea
                'type' => 'checkbox',
                'label' => 'form_label_heard_on',
            ),
			'messaggio' => array(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_messaggio',
			)
		)
	),

	// Ajax Contact form
	// Displayed and processed by the module Ajaxform
	'contact_ajax' => array
	(
		// The method which will process the form
		// Originally in libraries/ajaxform_process.php, this class can be copied in your theme libraries folder
		'process' => 'Ajaxform_Process::process_contact',

		// Messages Language index, as set in language/xx/form_lang.php
		'messages' => array(
			'success' => 'form_alert_error_message',
			'error' => 'form_alert_success_message',
		),
		'emails' => array
		(
			// To Site Administrator
			array
			(
				// Send the mail to the address filled in in the 'email' input of the form
				// Values can be :
				// - One plain Email address : my.name@mydomain.com
				// - 'form' to send it to the email of the form data
				// - 'site' to send it to the Email set in Ionize under Settings > Advanced > Email > Website
				// - 'contact' to send it to the Email set in Ionize under Settings > Advanced > Email > Contact
				// - 'info' to send it to the Email set in Ionize under Settings > Advanced > Email > Info
				// - 'technical' to send it to the Email set in Ionize under Settings > Advanced > Email > Info
				'email' => 'contact',

				// Translation item index
				'subject' => 'mail_website_contact_subject',

				// Used view : Located in /themes/your_theme/mail/contact.php
				'view' => 'mail/contact/to_admin_ajax',
			),
			// Send to user
			array
			(
				'email' => 'form',
				'subject' => 'mail_user_contact_subject',
				'view' => 'mail/contact/to_user_ajax',
			),
		),
		// Form definition: fields and rules
		'fields' => array
		(
			'name' => array
			(
				// CI validation rules
				'rules' => 'trim|required|min_length[3]|xss_clean',
				// Label translated index, as set in language/xx/form_lang.php
				// Will be used to display the label name in error messages
				'label' => 'form_label_firstname',
			),
			'email' => array(
				'rules' => 'trim|required|valid_email|xss_clean',
				'label' => 'form_label_email',
			),
			'message' => array(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_message',
			)
		)
	),

// Ajax career form
	// Displayed and processed by the module Ajaxform
	'career_ajax' => array
	(
		// The method which will process the form
		// Originally in libraries/ajaxform_process.php, this class can be copied in your theme libraries folder
		'process' => 'Ajaxform_Process::process_career',

		// Messages Language index, as set in language/xx/form_lang.php
		'messages' => array(
			'success' => 'form_alert_error_message',
			'error' => 'form_alert_success_message',
		),
		'emails' => array
		(
			// To Site Administrator
			array
			(
				// Send the mail to the address filled in in the 'email' input of the form
				// Values can be :
				// - One plain Email address : my.name@mydomain.com
				// - 'form' to send it to the email of the form data
				// - 'site' to send it to the Email set in Ionize under Settings > Advanced > Email > Website
				// - 'career' to send it to the Email set in Ionize under Settings > Advanced > Email > career
				// - 'info' to send it to the Email set in Ionize under Settings > Advanced > Email > Info
				// - 'technical' to send it to the Email set in Ionize under Settings > Advanced > Email > Info
				'email' => 'career',

				// Translation item index
				'subject' => 'mail_website_career_subject',

				// Used view : Located in /themes/your_theme/mail/career.php
				'view' => 'mail/career/to_admin_ajax',
			),
			// Send to user
			array
			(
				'email' => 'form',
				'subject' => 'mail_user_career_subject',
				'view' => 'mail/career/to_user_ajax',
			),
		),
		// Form definition: fields and rules
		'fields' => array
		(
			'name' => array
			(
				// CI validation rules
				'rules' => 'trim|required|min_length[3]|xss_clean',
				// Label translated index, as set in language/xx/form_lang.php
				// Will be used to display the label name in error messages
				'label' => 'form_label_firstname',
			),
			'email' => array(
				'rules' => 'trim|required|valid_email|xss_clean',
				'label' => 'form_label_email',
			),
			'message' => array(
				'rules' => 'trim|required|xss_clean',
				'label' => 'form_label_message',
			)
		)
	),
);