<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if ( ! function_exists('svg_reduce_coord'))
{
	/**
	 * Splitto un svg ad ogni M (ovvero ogni ripartenza), e quindi considero anche eventuali isole.
	 * Considero che tutte le altre coordinate siano consecutive e vicine, ad esempio come in una mappa, e pertanto semplifico selezionando 1 punto ogni N
	 */
	function svg_reduce_coord($data,$simplify = 15)
	{
		// primo passaggio: elimino tutti i decimali
		$data = svg_optimize_decimal($data,0);
		
		$return = '';
		
		// da qui in poi semplifico i punti
		$areas =  preg_split("/[M]+/",$data, -1, PREG_SPLIT_NO_EMPTY);
		foreach($areas as $k => $area) {

			// considero tutte le coordinate 
			$points =  preg_split("/[\sLCQTSz]+/",$area, -1, PREG_SPLIT_NO_EMPTY);
			
			foreach($points as $key => $point) {
				if($key == 0) {
					$return .= ' M ' . $point;
				}
				else {
					if(($key - 1) % $simplify == 0)
					$return .= ' L ' . $point;	
				}
				
			}
			$return . " Z";
		}
		
		return $return;

	}
}


/**
 * arrotondo i decimali dell'svg
 */
if ( ! function_exists('optimize_decimal'))
{
	function svg_optimize_decimal($coords,$decimal=0)
	{
		$instructions = explode(',',$coords);
		foreach($instructions as $key => $instruction) {
			
			$data[$key] = explode(' ',$instruction);
			// semplifico i valori riducendo a $decimal
			foreach($data[$key] as $k => $d) {
				if(is_numeric($d)) {
					if($decimal > 0) {
						// round
						$data[$key][$k] = round($d,$decimal);
					}
					else
					{
						// floor
						$data[$key][$k] = floor($d);
					}
				}
			}
			
			$data[$key] = implode(' ',$data[$key]);
		}
		
		// riunisco tutto
		$instructions = implode(',',$data);
		
		//return $coords;
		return $instructions;
	}
}
		