define(['angularAMD', 'angular-route', 'angular-animate','ng-file-upload','colorpicker','angular-cookie-law'], function(angularAMD) {

	var app = angular.module('webapp',['ngRoute','ngAnimate','ngFileUpload','colorpicker.module','angular-cookie-law']);
	
	// HOME CONFIGURATORE: DIRETTIVA
	app.directive('homeconfiguratore', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: true,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'home-configuratore',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM
					
				}); // timeout
			} // link
		};
	}).controller('HomeConfiguratoreController', ['$scope',
	function($scope) {

	}]);
	
	// HOME NEWS: DIRETTIVA
	app.directive('news', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: true,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'home-news',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	}).controller('NewsController', ['$scope',
	function($scope) {

	}]);
	
	// INTRO: DIRETTIVA
	app.directive('payoff', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: false,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'payoff',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	}).controller('PayoffController', ['$scope',
	function($scope) {

	}]);
	
	// SIDEBAR CONFIGURATORE: DIRETTIVA
	app.directive('configuratoreSidebar', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: false,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'configuratore-sidebar',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	});
	
	
	// ASSISTENZA: DIRETTIVA
	app.directive('assistenza', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: false,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'assistenza',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	}).controller('AssistenzaController', ['$scope',
	function($scope) {

	}]);
	
	// CONFIGURATORE: DIRETTIVA
	app.directive('configuratore', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: false,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'configuratore-component',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	}).controller('ConfiguratoreController', ['$scope','$rootScope',
	function($scope,$rootScope) {
    	
    	// animation
		$rootScope.$on('$routeChangeStart', function(event, currRoute, prevRoute){
			$scope.animation = currRoute.animation;
		});
		
		// TODO? intercetto gli eventi (upward) del colorpicker e li riemetto in broadcasting
		$scope.$on('colorpicker-closed',function(e) {
			$scope.$broadcast('downward-colorpicker-closed', e);
		});
		
	}]);
	
	// CONFIGURATORE: FACTORY per conservare i dati del configuratore
	app.factory("Configuratore",function() {
		
		var data = {};
		
		var update = function(value) {
			this.data = value;
		}
		
		return {
			data: data,
			update: update
		};

	});


	// CONFIGURATORE: ROUTING
	app.config(function($routeProvider,$controllerProvider) {
		
		$controllerProvider.allowGlobals();
		
		$routeProvider.when("/configuratore-0", angularAMD.route({
			// CONFIGURATORE 0
			templateUrl : base_url + 'configuratore-component/configuratore-0',
			controller : 'Configuratore0Controller',
			controllerUrl : theme_url + 'src/js/controller_configuratore-0.js',
			animation: 'animation-fade'
		})).when("/configuratore-1", angularAMD.route({
			// CONFIGURATORE 1
			templateUrl : base_url + 'configuratore-component/configuratore-1',
			controller : 'Configuratore1Controller',
			controllerUrl : theme_url + 'src/js/controller_configuratore-1.js',
			animation: 'animation-fade'
		})).when("/configuratore-2", angularAMD.route({
			// CONFIGURATORE 2
			templateUrl : base_url + 'configuratore-component/configuratore-2',
			controller : 'Configuratore2Controller',
			controllerUrl : theme_url + 'src/js/controller_configuratore-2.js',
			animation: 'animation-fade'
		})).when("/configuratore-3", angularAMD.route({
			// CONFIGURATORE 3
			templateUrl : base_url + 'configuratore-component/configuratore-3',
			controller : 'Configuratore3Controller',
			controllerUrl : theme_url + 'src/js/controller_configuratore-3.js',
			animation: 'animation-fade'
		})).when("/download", angularAMD.route({
			// DOWNLOAD
			templateUrl : base_url + 'download',
			controller : 'Configuratore4Controller',
			controllerUrl : theme_url + 'src/js/controller_configuratore-4.js',
			animation: 'animation-fade'
		})).otherwise({
			redirectTo : "/configuratore-0"
		});
	});
	

	// MAPPA
	app.directive('mappa', function($timeout) {

		return {
			restrict : 'E',
			transclude : true,
			scope : {id : "="},
			templateUrl: function(tElement, tAttrs) {
			  return base_url + 'mappa/' + tAttrs.id;
			},
			link: function postLink(elemen, attrs, tranclude) {

				// solo dopo dom ok
				$timeout(function() {
					
					// carico le lib che mi servono
					require(['snapsvg'], function(Snap) {
						
						// SNAP.SVG MAP
						var s = Snap("#italia");
						if(s) {
							var p = s.selectAll('.el:not(.active)');
							p.forEach(function(e,i) {
								e.attr({'fill':'#e0e0e0','stroke': '#fff','strokeWidth': 3});					// init
								e.mouseover(function() {e.animate({fill:'#00529C'},200,mina.easeinout); });		// mouse enter
								e.mouseout(function() {e.animate({fill:'#e0e0e0'},200,mina.easeoutout); });		// mouse out
							});
							var pactive = s.selectAll('.active');
							pactive.forEach(function(e,i) {
								e.attr({'fill':'#00529C','stroke': '#fff','strokeWidth': 1});					// init
							}); // if s
						} // snap
					}); // require
					
				}); // timeout
			} // link
		};
	}).controller('MappaController', ['$scope',
	function($scope) {

	}]); 

	return angularAMD.bootstrap(app);
	// return app;

});
