define(['app'], function (app) {
	
    app.controller('Configuratore1Controller', function ($scope,$location,$http,Configuratore,Upload) {
    	
    	// data
    	$scope.configuratore = Configuratore.data;
    	if(!$scope.configuratore.hasOwnProperty('data')) $scope.configuratore.data = {}; 
    	
    	// PREVENT DIRECT ACCESS TO THIS CONTROLLER
    	// se non ho un utente, torno a controller 0
    	if(!(parseInt($scope.configuratore.data.id_user)>0)) {
			$location.path( "configuratore-0" );
			$location.replace(); // e cancello il precedente elemento nell'history, impedendo all'utente di tornare qui
    	}
    	

		$scope.upload = function(files) {
			
			$('.file_upload').each(function() {
				
				// init progress
				$scope.configuratore.file = {
					progress: true
				};
				
				// sposto il pulsante
				$(this).find('.btn-file').addClass('activated');
				
				// mostro il progress
				$(this).find('.progress').removeClass('hide')
			});
			
			// per ogni file
			if (files && files.length) {
				for (var i = 0; i < files.length; i++) {
					var file = files[i];
					
					Upload
					.upload({
						url : base_url + 'ajaxform/upload',
						// url: 'http://demo.avipitalia.it',
						fields : {
							// ionize sovrascrive MY_Upload nativo di Code Igniter
							// la classe richiede ulteriori campi tipicamente usati da admin.
							// in questo caso DropZone, utilizzato da admin, richiede il campo file_input_prefix
							// con un numero incrementale (ora ne basta uno) che identifica l'indice dell'immagine
							'file_input_prefix' : 0
						},
						file : file
					})
					.progress(function(evt) {
						var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
						
						// lo utilizzo per dichiarare che un file è in progress
						$scope.configuratore.file = {
							progress: progressPercentage + '%'
						};
						
						$('.file_upload').each(function() {
							
							// muovo il progress
							$(this).find('.progress-bar').css({width:$scope.configuratore.file.progress + '%'}).text($scope.configuratore.file.progress);
						});
						
						// console.log('progress: ' + progressPercentage + '% ' + evt.config.file.name);
					})
					.success(function(data, status, headers, config) {
						
						$('.file_upload').each(function() {
							// tolgo e disattivo progress bar
							$(this).find('.progress-bar').removeClass('progress-bar-striped active');
							
							// passo i dati nello scope
							$scope.configuratore.file = {
								data:data.data,
								config:config,
								status:status,
								headers:headers
							};
							
							// data
							$scope.configuratore.data.year = data.data.year;
							$scope.configuratore.data.month = data.data.month;
							$scope.configuratore.data.day = data.data.day;
							$scope.configuratore.data.banner = data.data.file_name;
							
							// salvo
							$scope.change();
						});
						
						// console.log('file ' + config.file.name + 'uploaded. Response: ' + data);
					});
				}
			}
		}; 

    	
    	// VERIFICA DATI SPECIFICA PER CONFIGURATORE 1
    	// TODO: aggiungere gli isset
    	$scope.check = function() {
			return $scope.form.email.$valid
					&& $scope.form.attivita.$valid
					&& Boolean($scope.form.informativa.$modelValue)
					&& $scope.configuratore.file.status;
    	}

		// check fields
    	$scope.change = function() {
    		Configuratore.update($scope.configuratore);
    	}
    	
    	$scope.submit = function() {
    		
    		if(!$scope.check()) return false;
    		
    		// inviando l'utente accetta: non  è più draft
    		$scope.configuratore.data.draft = 0;
    		
    		// invoca il server e ottiene l'id, caricandolo nello $scope.configuratore
    		$http.post(base_url + 'ajaxform/save',$scope.configuratore.data)
    		.success(function(response) {
    			
				if(response.data && !response.error) {
					
					$scope.configuratore.data = response.data;
		    		Configuratore.update($scope.configuratore); // or digest?!

					
		    		// next step
					$location.path( "configuratore-2" );					
				}

    		})
    		.error(function(data){
    			alert('Errore in fase di startup del configuratore.');
    		});

    	}

        
    });
});