define(['app'], function (app) {
	
	// verifico il caricamento delle immagini
	app.directive('imageonload', function() {
        return {
            restrict: 'A',
            link: function(scope, element, attrs) {
                element.bind('load', function() {
                    //call the function that was passed
                    scope.$apply(attrs.imageonload);
                });
            }
        };
    })
	
    app.controller('Configuratore2Controller', function ($scope,$document,$http,$location,Configuratore) {

    	// data
    	$scope.configuratore = Configuratore.data;
    	if(!$scope.configuratore.hasOwnProperty('data')) $scope.configuratore.data = {};
    	
    	// prendo i dati dal server
    	/*
    	$http.post(base_url + 'ajaxform/get',$scope.configuratore.data).success(function(response) {
    		$scope.configuratore.data = response.data;
    		Configuratore.update($scope.configuratore); // or digest?!	
    	});
    	*/
    	
    	// PREVENT DIRECT ACCESS TO THIS CONTROLLER
    	// se non ho un utente, torno a controller 0
    	if(!(parseInt($scope.configuratore.data.id_user)>0)) {
			$location.path( "configuratore-0" );
			$location.replace(); // e cancello il precedente elemento nell'history, impedendo all'utente di tornare qui
    	}
    	
		// strutture dati
    	$scope.configuratore.defaults = {};
    	$scope.configuratore.tools = {};
    	
    	// FONTS
    	// fonts disponibili
    	$scope.configuratore.defaults.fonts = [
    		{
    			'label': 'Nessun testo',
    			'value': 'NONE',
    			'icon': 'stop'
    		},
    		{
    			'label': 'College',
    			'value': 'VARSITY',
				'icon': 'adjust'    			
    		},
    		{
    			'label': 'Divertente',
    			'value': 'ACTION',
    			'icon': 'tint'
    		},
    		{
    			'label': 'Keep Calm',
    			'value': 'KEEPCALM',
    			'icon': 'certificate'
    		},
    		{
    			'label': 'Acuto',
    			'value': 'VIAFONT',
    			'icon': 'certificate'
    		},
    		{
    			'label': 'Evidenziato',
    			'value': 'ACNE',
    			'icon': 'certificate'
    		},
    		{
    			'label': 'Retinato',
    			'value': 'PRISMA',
    			'icon': 'certificate'
    		},
    		{
    			'label': 'Typewriter',
    			'value': 'TYPEWRITER',
    			'icon': 'certificate'
    		}
    	];

    	
    	// FILTERS
    	// filter disponibili
    	$scope.configuratore.defaults.filters = [
    		{
    			'label': 'Normale',
    			'value': 'NONE',
    			'icon': 'stop'
    		},
    		{
    			'label': 'Contrasto',
    			'value': 'CONTRAST',
				'icon': 'adjust'    			
    		},
    		{
    			'label': 'Colore',
    			'value': 'COLORIZE',
    			'icon': 'tint'
    		},
    		{
    			'label': 'Sfoca',
    			'value': 'BLUR',
    			'icon': 'certificate'
    		}
    	];


    	
    	// PROGETTI
    	// progetti disponibili
    	$scope.configuratore.progetti = {
    		'cartello': {
    			'active':true
    		},
    		'pensilina': {
    		},
    		'palina': {
    		},
    		'cavalcavia': {
    		}
    	};
    	
    	// POSIZIONAMENTI
    	// posizionamenti disponibili
    	$scope.configuratore.defaults.positions = [
    		{
    			'label': 'Centrato',
    			'value': 'MIDDLE',
    			'icon': 'screenshot'
    		},
    		{
    			'label': 'In alto',
    			'value': 'TOP',
    			'icon': 'triangle-top'
    		},
    		{
    			'label': 'A destra',
    			'value': 'RIGHT',
    			'icon': 'triangle-right'
    		},
    		{
    			'label': 'In basso',
    			'value': 'BOTTOM',
    			'icon': 'triangle-bottom'
    		},
    		{
    			'label': 'A sinistra',
    			'value': 'LEFT',
    			'icon': 'triangle-left'
    		},
    		{
    			'label': 'Esteso',
    			'value': 'FILL',
    			'icon': 'fullscreen'
    		},
    		{
    			'label': 'Ripetuto',
    			'value': 'PATTERN',
    			'icon': 'th'
    		}
    	];
    	
    	// DATA
    	
    	// COLORPICKER
    	
		// intercetto gli eventi (downward) che app mi broadcasta
		$scope.$on('downward-colorpicker-closed',function(e){

	    	// background è la versione priva di # di backgroundHex
	    	if($scope.configuratore.tools.background)
	    	$scope.configuratore.data.background = $scope.configuratore.tools.background.substring(1);
	    	
	    	// color
	    	if($scope.configuratore.tools.color)
	    	$scope.configuratore.data.color = $scope.configuratore.tools.color.substring(1);
	    	
	    	Configuratore.update($scope.configuratore);
	    	
	    	// save on db
			$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
	    	
	    	$scope.$digest();
	    	return true;
		});
		

		// FILTRO
		$scope.cambiaFiltro = function(filtro) {
			$scope.configuratore.data.filter = filtro;
			
			// update tools
    		for(var k in $scope.configuratore.defaults.filters) {
    			if($scope.configuratore.defaults.filters[k].value == $scope.configuratore.data.filter) $scope.configuratore.tools.activeFilter = $scope.configuratore.defaults.filters[k].label;
    		}
    		
    		// fix: se attivo COLORIZE e background è bianco, allora lo forzo ad altro colore
    		// altrimenti l'utente non si accorge del cambiamento
    		if(filtro=='COLORIZE' && $scope.configuratore.data.background == 'ffffff') {
    			$scope.configuratore.data.background = '00529C';
    		}
    		
			// update model
			Configuratore.update($scope.configuratore);
			
			// save on db
			$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
		}
		
		// FILTRO
		$scope.cambiaFont = function(font) {
			$scope.configuratore.data.font = font;

			// update tools
    		for(var k in $scope.configuratore.defaults.fonts) {
    			if($scope.configuratore.defaults.fonts[k].value == $scope.configuratore.data.font) $scope.configuratore.tools.activeFont = $scope.configuratore.defaults.fonts[k].label;
    		}

			// update model
			Configuratore.update($scope.configuratore);
			
			// save on db
			$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
		}
		
		// POSIZIONE
		$scope.cambiaPosizione = function(position) {
			$scope.configuratore.data.position = position;

			// update tools
    		for(var k in $scope.configuratore.defaults.positions) {
    			if($scope.configuratore.defaults.positions[k].value == $scope.configuratore.data.position) $scope.configuratore.tools.activePosition = $scope.configuratore.defaults.positions[k].label;
    		}
    		
			// update model
			Configuratore.update($scope.configuratore);
			
			// save on db
			$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
		}
    	
    	
    	// LOADER
    	
    	// barra loading image
	    $scope.imageonload = function(p) {
	    	if ($scope.configuratore.progetti.hasOwnProperty(p)) {
		    	$scope.configuratore.progetti[p].loaded = true;
	    	}
	    	else {
				$scope.configuratore.progetti[p] = {
					loaded: true
				}
	    	}
	    }
	    
    	$scope.progetto = function(progetto) {
    		
    		progetto = typeof progetto !== 'undefined' ? progetto : 'cartello';
    		
    		// cambio lo status active di tutti in false
    		for (var p in $scope.configuratore.progetti) {
   				if ($scope.configuratore.progetti.hasOwnProperty(p)) {
   					
   					// init: eredito eventuale active precedente
   					if(!progetto && $scope.configuratore.progetti[p].active) progetto = p;  
   					
   					// resetto lo stato dei progetti
   					$scope.configuratore.progetti[p].active = false;
	    			$scope.configuratore.progetti[p].loaded = false;
   				}
			}
    		// attivo lo status active per quello selezionato
    		// se esiste
    		if($scope.configuratore.progetti.hasOwnProperty(progetto)) {
	    		$scope.configuratore.progetti[progetto].active = true;
	    		
	    		// cambio il progetto corrente
	    		$scope.configuratore.data.progetto = progetto;
	    		
	    		Configuratore.update($scope.configuratore);
	    		
				// save on db
				$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
	    		
	    		return true;
    		}

			 return false;   		
    		
    	}
    	
     	// VERIFICA DATI SPECIFICA PER CONFIGURATORE 2
    	$scope.check = function() {

			// verifico step attuale
			return $scope.form.nome.$valid
				&& $scope.form.cognome.$valid
				&& $scope.form.email.$valid
				&& $scope.form.telefono.$valid
				&& $scope.form.cap.$valid
				&& $scope.form.attivita.$valid;
    	}

		// check fields
    	$scope.change = function() {
    		Configuratore.update($scope.configuratore);
    	};
    	
    	// SET to default value
    	$scope.reset = function() {
    		$scope.configuratore.data.color = '333333';
	    	$scope.configuratore.data.background = '00529C';
	    	$scope.configuratore.data.filter = 'NONE';
			$scope.configuratore.data.position = 'MIDDLE';
			$scope.configuratore.data.font = 'NONE';
    		
    		Configuratore.update($scope.configuratore);
    	};
    	
    	
    	$scope.submit = function() {
    		
    		if(!$scope.check()) return false;
    		
    		// invoca il server e ottiene l'id, caricandolo nello $scope.configuratore
    		$http.post(base_url + 'ajaxform/save',$scope.configuratore.data)
    		.success(function(response) {
    			
				if(response.data && !response.error) {
					
					$scope.configuratore.data = response.data;
		    		Configuratore.update($scope.configuratore); // or digest?!

		    		// next step
					$location.path( "configuratore-3" );					
				}

    		})
    		.error(function(data){
    			alert('Errore in fase di startup del configuratore.');
    		});
    	};

    });
}); 