/*
require([theme_url + 'src/js/rjsconfig.js'],function(rjsconfig){
	
	// carico la configurazione di requirejs
	// la configurazione è costruita come un modulo da inizializzare, a cui posso passare parametri.
	require.config(r = rjsconfig({
		theme_url: theme_url	
	}));

});
*/

var theme_url = theme_url || 'themes/avipitalia/';

require.config({
	baseUrl : theme_url,
	urlArgs : "bust=" + (new Date()).getTime(),
	waitSeconds : 2,
	paths : {
		// require css
		'require-css' : 'src/bower_components/require-css/css.min',
		'css-builder' : 'src/bower_components/require-css/css-builder',
		'normalize' : 'src/bower_components/require-css/normalize',
		
		// 'almond' : 'bower_components/almond/almond', // only in build file

		// bootstrap
		'bootstrap' : 'src/bower_components/bootstrap-sass/assets/javascripts/bootstrap.min',
		'bootstrap-select': 'src/bower_components/bootstrap-select/dist/js/bootstrap-select.min',
		'bootstrap-tabdrop': 'src/bower_components/bootstrap-tabdrop/build/js/bootstrap-tabdrop.min',
		
		// masonry
		'masonry' : 'src/bower_components/masonry/dist/masonry.pkgd.min',
		
		// jquery
		'jquery' : 'src/bower_components/jquery/dist/jquery.min',
		'imagelightbox': 'src/bower_components/imagelightbox/dist/imagelightbox.min',
		
		// drops
		'_retina' : 'src/bower_components/retinajs/dist/retina',			// load retina images
		'_offcanvas' : 'src/js/drops/_offcanvas/_main',						// push navigation	

		// app
		'app' : 'src/js/app',
		'run' : 'src/js/run',
		// 'main': 'js/main', // only in build file

		// angular
		'angular' : 'src/bower_components/angular/angular',
		'angular-route' : 'src/bower_components/angular-route/angular-route',
		'angular-animate' : 'src/bower_components/angular-animate/angular-animate',
		'angularAMD' : 'src/bower_components/angularAMD/angularAMD',
		'ng-file-upload' : 'src/bower_components/ng-file-upload/ng-file-upload-all.min',
		'colorpicker': 'src/bower_components/angular-bootstrap-colorpicker/js/bootstrap-colorpicker-module.min',
		
		// cookie law
		'angular-cookie-law' : 'src/bower_components/angular-cookie-law/dist/angular-cookie-law',

		// retro
		'html5shiv' : 'src/bower_components/html5shiv/dist/html5shiv.min',
		'respond' : 'src/bower_components/dest/respond.min',
		
		// dom ready
		'domReady': 'src/bower_components/domReady/domReady',
		
		// svg
		'snapsvg': 'src/bower_components/snap.svg/dist/snap.svg',
		'configuratore0' : 'src/js/controller_configuratore-0',
		'configuratore1' : 'src/js/controller_configuratore-1',
		'configuratore2' : 'src/js/controller_configuratore-2',
		'configuratore3' : 'src/js/controller_configuratore-3',
		'configuratore4' : 'src/js/controller_configuratore-4',
	},
    priority: [
        "angular"
    ],
	shim : {
		// bootstrap
		"bootstrap" : {
			"deps" : ['jquery']
		},
		"bootstrap-select" : {
			"deps" : ['bootstrap','css!src/bower_components/bootstrap-select/dist/css/bootstrap-select.min.css']
		},
		"bootstrap-tabdrop" : {
			"deps" : ['bootstrap','css!src/bower_components/bootstrap-tabdrop/build/css/tabdrop.css']
		},
		"masonry": {
			"deps" : ['jquery'],
			"export" : ['Masonry']
		},
		
		// domready components
		"_offcanvas" : {
			"deps" : ['jquery']
		},
		
		// jquery
		'imagelightbox' : {
			"deps" : ['jquery','css!src/bower_components/imagelightbox/dist/imagelightbox.css']
		},

		// angular
		'angularAMD' : ['angular'],
		'angular-route' : ['angular'],
		'angular-animate' : ['angular'],
		'ng-file-upload' : {
			"deps" : ['angular'],
			"export" : ['angular']
		},
		'colorpicker' : {
			"deps" : ['angular','css!src/bower_components/angular-bootstrap-colorpicker/css/colorpicker.min.css'],
			"export" : ['angular']
		},
		'angular-cookie-law' : {
			"deps" : ['angular','css!src/bower_components/angular-cookie-law/dist/angular-cookie-law.css'],
			"export" : ['angular']
		},

	},
	deps : ['app', 'run'],
	map : {
		'*' : {
			'css' : 'require-css' // or whatever the path to require-css is
		}
	}
}); 

