define(function (options) {
	
	var module = {};

	function set_module(opts) {

		module = {
			baseUrl : opts.theme_url,
			urlArgs: "bust=" +  (new Date()).getTime(),
			waitSeconds: 1,
			paths : {
				// require
				'require-css' : 'src/bower_components/require-css/css.min',
		
				// bootstrap
				'bootstrap' : 'src/bower_components/bootstrap/dist/js/bootstrap.min',
		
				// jquery
				'jquery' : 'src/bower_components/jquery/dist/jquery.min',
		
				// app
				'app' : 'src/js/app',
				'run' : 'src/js/run',
				
				// angular
				'angular' : 'src/bower_components/angular/angular.min',
				'angular-route' : 'src/bower_components/angular-route/angular-route.min',
				'angularAMD' : 'src/bower_components/angularAMD/angularAMD.min',
				
				// retro
				'html5shiv' : 'src/bower_components/html5shiv/dist/html5shiv.min',
				'respond' : 'src/bower_components/dest/respond.min',
				
				// retina
				'retina' : 'src/bower_components/retinajs/dist/retina.min',
				
				// dom ready
				'domReady': 'src/bower_components/domReady/domReady.js'
			},
			shim : {
				// bootstrap
				"bootstrap" : {"deps" :['jquery']},
		
				// angular
				'angularAMD' : ['angular'],
				'angular-route' : ['angular'],
				
				// retina
				"retina": {
					exports: 'Retina'	
				}
			},
			deps : ['app','run'],
			map : {
				'*' : {
					'css' : 'require-css' // or whatever the path to require-css is
				}
			}
		}; // end module
	} // end setter
	

	// inizializzo il modulo passando i parametri
    var init = function (opts) {
		this.module = set_module(opts);

        return module;

    };
    
    return init;

});