define(['angularAMD', 'angular-route', 'angular-animate','ng-file-upload','colorpicker','angular-cookie-law','snapsvg'], function(angularAMD) {

	var app = angular.module('webapp',['ngRoute','ngAnimate','ngFileUpload','colorpicker.module','angular-cookie-law']);
	
	// HOME CONFIGURATORE: DIRETTIVA
	app.directive('homeconfiguratore', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: true,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'home-configuratore',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM
					
				}); // timeout
			} // link
		};
	}).controller('HomeConfiguratoreController', ['$scope',
	function($scope) {

	}]);
	
	// HOME NEWS: DIRETTIVA
	app.directive('news', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: true,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'home-news',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	}).controller('NewsController', ['$scope',
	function($scope) {

	}]);
	
	// INTRO: DIRETTIVA
	app.directive('payoff', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: false,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'payoff',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	}).controller('PayoffController', ['$scope',
	function($scope) {

	}]);
	
	// SIDEBAR CONFIGURATORE: DIRETTIVA
	app.directive('configuratoreSidebar', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: false,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'configuratore-sidebar',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	});
	
	
	// ASSISTENZA: DIRETTIVA
	app.directive('assistenza', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: false,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'assistenza',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	}).controller('AssistenzaController', ['$scope',
	function($scope) {

	}]);
	
	// CONFIGURATORE: DIRETTIVA
	app.directive('configuratore', function($timeout) {
		return {
			restrict : 'E',
			transclude : true,
			replace: false,
			scope : {
				title : '@'
			},
			templateUrl : base_url + 'configuratore-component',
			link: function postLink(elem, attrs, tranclude) {
				// solo dopo dom ok
				$timeout(function() {
					// do something with DOM					
				}); // timeout
			} // link
		};
	}).controller('ConfiguratoreController', ['$scope','$rootScope',
	function($scope,$rootScope) {
    	
    	// animation
		$rootScope.$on('$routeChangeStart', function(event, currRoute, prevRoute){
			$scope.animation = currRoute.animation;
		});
		
		// TODO? intercetto gli eventi (upward) del colorpicker e li riemetto in broadcasting
		$scope.$on('colorpicker-closed',function(e) {
			$scope.$broadcast('downward-colorpicker-closed', e);
		});
		
	}]);
	
	// CONFIGURATORE: FACTORY per conservare i dati del configuratore
	app.factory("Configuratore",function() {
		
		var data = {};
		
		var update = function(value) {
			this.data = value;
		}
		
		return {
			data: data,
			update: update
		};

	});
	
	// CONFIGURATORE 0 CONTROLLER
	var Configuratore0Controller = function($scope,$http,$location,Configuratore) {
			// data
	    	$scope.configuratore = Configuratore.data;
	    	$scope.configuratore.data = {
	    		form: 'configuratore',
	    		draft: 1
	    	};
	    	
	    	// l'avvio del configuratore genera un id e crea la riga nel db
	    	$scope.submit = function() {
	    		
	    		// invoca il server e ottiene l'id, caricandolo nello $scope.configuratore
	    		$http.post(base_url + 'ajaxform/init',$scope.configuratore.data)
	    		.success(function(data) {
	    			
	    			// acquisisco id_user
					$scope.configuratore.data.id_user = data.id_user;
					
		    		// final redirect to next step
					$location.path( "configuratore-1" );
					$location.replace(); // e cancello il precedente elemento nell'history, costringendo l'utente che fa back a tornare in home
	    		})
	    		.error(function(data){
	    			alert('Errore in fase di startup del configuratore.');
	    		});
	    		
	    	};
	}	
	app.controller('Configuratore0Controller', ['$scope','$http','$location','Configuratore', Configuratore0Controller]);
	
	// CONFIGURATORE 1 CONTROLLER
	var Configuratore1Controller = function($scope,$location,$http,Configuratore,Upload) {
   	
    	// data
    	$scope.configuratore = Configuratore.data;
    	if(!$scope.configuratore.hasOwnProperty('data')) $scope.configuratore.data = {}; 
    	
    	// PREVENT DIRECT ACCESS TO THIS CONTROLLER
    	// se non ho un utente, torno a controller 0
    	if(!(parseInt($scope.configuratore.data.id_user)>0)) {
			$location.path( "configuratore-0" );
			$location.replace(); // e cancello il precedente elemento nell'history, impedendo all'utente di tornare qui
    	}
    	

		$scope.upload = function(files) {
			
			$('.file_upload').each(function() {
				
				// init progress
				$scope.configuratore.file = {
					progress: true
				};
				
				// sposto il pulsante
				$(this).find('.btn-file').addClass('activated');
				
				// mostro il progress
				$(this).find('.progress').removeClass('hide')
			});
			
			// per ogni file
			if (files && files.length) {
				for (var i = 0; i < files.length; i++) {
					var file = files[i];
					
					Upload
					.upload({
						url : base_url + 'ajaxform/upload',
						// url: 'http://demo.avipitalia.it',
						fields : {
							// ionize sovrascrive MY_Upload nativo di Code Igniter
							// la classe richiede ulteriori campi tipicamente usati da admin.
							// in questo caso DropZone, utilizzato da admin, richiede il campo file_input_prefix
							// con un numero incrementale (ora ne basta uno) che identifica l'indice dell'immagine
							'file_input_prefix' : 0
						},
						file : file
					})
					.progress(function(evt) {
						var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
						
						// lo utilizzo per dichiarare che un file è in progress
						$scope.configuratore.file = {
							progress: progressPercentage + '%'
						};
						
						$('.file_upload').each(function() {
							
							// muovo il progress
							$(this).find('.progress-bar').css({width:$scope.configuratore.file.progress + '%'}).text($scope.configuratore.file.progress);
						});
						
						// console.log('progress: ' + progressPercentage + '% ' + evt.config.file.name);
					})
					.success(function(data, status, headers, config) {
						
						$('.file_upload').each(function() {
							// tolgo e disattivo progress bar
							$(this).find('.progress-bar').removeClass('progress-bar-striped active');
							
							// passo i dati nello scope
							$scope.configuratore.file = {
								data:data.data,
								config:config,
								status:status,
								headers:headers
							};
							
							// data
							$scope.configuratore.data.year = data.data.year;
							$scope.configuratore.data.month = data.data.month;
							$scope.configuratore.data.day = data.data.day;
							$scope.configuratore.data.banner = data.data.file_name;
							
							// salvo
							$scope.change();
						});
						
						// console.log('file ' + config.file.name + 'uploaded. Response: ' + data);
					});
				}
			}
		}; 

    	
    	// VERIFICA DATI SPECIFICA PER CONFIGURATORE 1
    	// TODO: aggiungere gli isset
    	$scope.check = function() {
			return $scope.form.email.$valid
					&& $scope.form.attivita.$valid
					&& Boolean($scope.form.informativa.$modelValue)
					&& $scope.configuratore.file.status;
    	}

		// check fields
    	$scope.change = function() {
    		Configuratore.update($scope.configuratore);
    	}
    	
    	$scope.submit = function() {
    		
    		if(!$scope.check()) return false;
    		
    		// inviando l'utente accetta: non  è più draft
    		$scope.configuratore.data.draft = 0;
    		
    		// invoca il server e ottiene l'id, caricandolo nello $scope.configuratore
    		$http.post(base_url + 'ajaxform/save',$scope.configuratore.data)
    		.success(function(response) {
    			
				if(response.data && !response.error) {
					
					$scope.configuratore.data = response.data;
		    		Configuratore.update($scope.configuratore); // or digest?!

					
		    		// next step
					$location.path( "configuratore-2" );					
				}

    		})
    		.error(function(data){
    			alert('Errore in fase di startup del configuratore.');
    		});

    	}
	};
	app.controller('Configuratore1Controller', ['$scope','$http','$location','Configuratore','Upload', Configuratore1Controller]);
	
	// verifico il caricamento delle immagini
	app.directive('imageonload', function() {
        return {
            restrict: 'A',
            link: function(scope, element, attrs) {
                element.bind('load', function() {
                    //call the function that was passed
                    scope.$apply(attrs.imageonload);
                });
            }
        };
    })
	
	
	// CONFIGURATORE 2 CONTROLLER
	var Configuratore2Controller = function($scope,$http,$location,$document,Configuratore) {
    	// data
    	$scope.configuratore = Configuratore.data;
    	if(!$scope.configuratore.hasOwnProperty('data')) $scope.configuratore.data = {};
    	
    	// prendo i dati dal server
    	/*
    	$http.post(base_url + 'ajaxform/get',$scope.configuratore.data).success(function(response) {
    		$scope.configuratore.data = response.data;
    		Configuratore.update($scope.configuratore); // or digest?!	
    	});
    	*/
    	
    	// PREVENT DIRECT ACCESS TO THIS CONTROLLER
    	// se non ho un utente, torno a controller 0
    	if(!(parseInt($scope.configuratore.data.id_user)>0)) {
			$location.path( "configuratore-0" );
			$location.replace(); // e cancello il precedente elemento nell'history, impedendo all'utente di tornare qui
    	}
    	
		// strutture dati
    	$scope.configuratore.defaults = {};
    	$scope.configuratore.tools = {};
    	
    	// FONTS
    	// fonts disponibili
    	$scope.configuratore.defaults.fonts = [
    		{
    			'label': 'Nessun testo',
    			'value': 'NONE',
    			'icon': 'stop'
    		},
    		{
    			'label': 'College',
    			'value': 'VARSITY',
				'icon': 'adjust'    			
    		},
    		{
    			'label': 'Divertente',
    			'value': 'ACTION',
    			'icon': 'tint'
    		},
    		{
    			'label': 'Keep Calm',
    			'value': 'KEEPCALM',
    			'icon': 'certificate'
    		},
    		{
    			'label': 'Acuto',
    			'value': 'VIAFONT',
    			'icon': 'certificate'
    		},
    		{
    			'label': 'Evidenziato',
    			'value': 'ACNE',
    			'icon': 'certificate'
    		},
    		{
    			'label': 'Retinato',
    			'value': 'PRISMA',
    			'icon': 'certificate'
    		},
    		{
    			'label': 'Typewriter',
    			'value': 'TYPEWRITER',
    			'icon': 'certificate'
    		}
    	];

    	
    	// FILTERS
    	// filter disponibili
    	$scope.configuratore.defaults.filters = [
    		{
    			'label': 'Normale',
    			'value': 'NONE',
    			'icon': 'stop'
    		},
    		{
    			'label': 'Contrasto',
    			'value': 'CONTRAST',
				'icon': 'adjust'    			
    		},
    		{
    			'label': 'Colore',
    			'value': 'COLORIZE',
    			'icon': 'tint'
    		},
    		{
    			'label': 'Sfoca',
    			'value': 'BLUR',
    			'icon': 'certificate'
    		}
    	];


    	
    	// PROGETTI
    	// progetti disponibili
    	$scope.configuratore.progetti = {
    		'cartello': {
    			'active':true
    		},
    		'pensilina': {
    		},
    		'palina': {
    		},
    		'cavalcavia': {
    		}
    	};
    	
    	// POSIZIONAMENTI
    	// posizionamenti disponibili
    	$scope.configuratore.defaults.positions = [
    		{
    			'label': 'Centrato',
    			'value': 'MIDDLE',
    			'icon': 'screenshot'
    		},
    		{
    			'label': 'In alto',
    			'value': 'TOP',
    			'icon': 'triangle-top'
    		},
    		{
    			'label': 'A destra',
    			'value': 'RIGHT',
    			'icon': 'triangle-right'
    		},
    		{
    			'label': 'In basso',
    			'value': 'BOTTOM',
    			'icon': 'triangle-bottom'
    		},
    		{
    			'label': 'A sinistra',
    			'value': 'LEFT',
    			'icon': 'triangle-left'
    		},
    		{
    			'label': 'Esteso',
    			'value': 'FILL',
    			'icon': 'fullscreen'
    		},
    		{
    			'label': 'Ripetuto',
    			'value': 'PATTERN',
    			'icon': 'th'
    		}
    	];
    	
    	// DATA
    	
    	// COLORPICKER
    	
		// intercetto gli eventi (downward) che app mi broadcasta
		$scope.$on('downward-colorpicker-closed',function(e){

	    	// background è la versione priva di # di backgroundHex
	    	if($scope.configuratore.tools.background)
	    	$scope.configuratore.data.background = $scope.configuratore.tools.background.substring(1);
	    	
	    	// color
	    	if($scope.configuratore.tools.color)
	    	$scope.configuratore.data.color = $scope.configuratore.tools.color.substring(1);
	    	
	    	Configuratore.update($scope.configuratore);
	    	
	    	// save on db
			$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
	    	
	    	$scope.$digest();
	    	return true;
		});
		

		// FILTRO
		$scope.cambiaFiltro = function(filtro) {
			$scope.configuratore.data.filter = filtro;
			
			// update tools
    		for(var k in $scope.configuratore.defaults.filters) {
    			if($scope.configuratore.defaults.filters[k].value == $scope.configuratore.data.filter) $scope.configuratore.tools.activeFilter = $scope.configuratore.defaults.filters[k].label;
    		}
    		
    		// fix: se attivo COLORIZE e background è bianco, allora lo forzo ad altro colore
    		// altrimenti l'utente non si accorge del cambiamento
    		if(filtro=='COLORIZE' && $scope.configuratore.data.background == 'ffffff') {
    			$scope.configuratore.data.background = '00529C';
    		}
    		
			// update model
			Configuratore.update($scope.configuratore);
			
			// save on db
			$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
		}
		
		// FILTRO
		$scope.cambiaFont = function(font) {
			$scope.configuratore.data.font = font;

			// update tools
    		for(var k in $scope.configuratore.defaults.fonts) {
    			if($scope.configuratore.defaults.fonts[k].value == $scope.configuratore.data.font) $scope.configuratore.tools.activeFont = $scope.configuratore.defaults.fonts[k].label;
    		}

			// update model
			Configuratore.update($scope.configuratore);
			
			// save on db
			$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
		}
		
		// POSIZIONE
		$scope.cambiaPosizione = function(position) {
			$scope.configuratore.data.position = position;

			// update tools
    		for(var k in $scope.configuratore.defaults.positions) {
    			if($scope.configuratore.defaults.positions[k].value == $scope.configuratore.data.position) $scope.configuratore.tools.activePosition = $scope.configuratore.defaults.positions[k].label;
    		}
    		
			// update model
			Configuratore.update($scope.configuratore);
			
			// save on db
			$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
		}
    	
    	
    	// LOADER
    	
    	// barra loading image
	    $scope.imageonload = function(p) {
	    	if ($scope.configuratore.progetti.hasOwnProperty(p)) {
		    	$scope.configuratore.progetti[p].loaded = true;
	    	}
	    	else {
				$scope.configuratore.progetti[p] = {
					loaded: true
				}
	    	}
	    }
	    
    	$scope.progetto = function(progetto) {
    		
    		progetto = typeof progetto !== 'undefined' ? progetto : 'cartello';
    		
    		// cambio lo status active di tutti in false
    		for (var p in $scope.configuratore.progetti) {
   				if ($scope.configuratore.progetti.hasOwnProperty(p)) {
   					
   					// init: eredito eventuale active precedente
   					if(!progetto && $scope.configuratore.progetti[p].active) progetto = p;  
   					
   					// resetto lo stato dei progetti
   					$scope.configuratore.progetti[p].active = false;
	    			$scope.configuratore.progetti[p].loaded = false;
   				}
			}
    		// attivo lo status active per quello selezionato
    		// se esiste
    		if($scope.configuratore.progetti.hasOwnProperty(progetto)) {
	    		$scope.configuratore.progetti[progetto].active = true;
	    		
	    		// cambio il progetto corrente
	    		$scope.configuratore.data.progetto = progetto;
	    		
	    		Configuratore.update($scope.configuratore);
	    		
				// save on db
				$http.post(base_url + 'ajaxform/save',$scope.configuratore.data).success(function(response) {});
	    		
	    		return true;
    		}

			 return false;   		
    		
    	}
    	
     	// VERIFICA DATI SPECIFICA PER CONFIGURATORE 2
    	$scope.check = function() {

			// verifico step attuale
			return $scope.form.nome.$valid
				&& $scope.form.cognome.$valid
				&& $scope.form.email.$valid
				&& $scope.form.telefono.$valid
				&& $scope.form.cap.$valid
				&& $scope.form.attivita.$valid;
    	}

		// check fields
    	$scope.change = function() {
    		Configuratore.update($scope.configuratore);
    	};
    	
    	// SET to default value
    	$scope.reset = function() {
    		$scope.configuratore.data.color = '333333';
	    	$scope.configuratore.data.background = '00529C';
	    	$scope.configuratore.data.filter = 'NONE';
			$scope.configuratore.data.position = 'MIDDLE';
			$scope.configuratore.data.font = 'NONE';
    		
    		Configuratore.update($scope.configuratore);
    	};
    	
    	
    	$scope.submit = function() {
    		
    		if(!$scope.check()) return false;
    		
    		// invoca il server e ottiene l'id, caricandolo nello $scope.configuratore
    		$http.post(base_url + 'ajaxform/save',$scope.configuratore.data)
    		.success(function(response) {
    			
				if(response.data && !response.error) {
					
					$scope.configuratore.data = response.data;
		    		Configuratore.update($scope.configuratore); // or digest?!

		    		// next step
					$location.path( "configuratore-3" );					
				}

    		})
    		.error(function(data){
    			alert('Errore in fase di startup del configuratore.');
    		});
    	};
	};
	app.controller('Configuratore2Controller', ['$scope','$location','$document','Configuratore', Configuratore2Controller]);
	
	// CONFIGURATORE 3 CONTROLLER
	var Configuratore3Controller = function($scope,$location,Configuratore) {
    	// data
    	$scope.configuratore = Configuratore.data;
    	if(!$scope.configuratore.hasOwnProperty('data')) $scope.configuratore.data = {};
    	
    	// PREVENT DIRECT ACCESS TO THIS CONTROLLER
    	// se non ho un utente, torno a controller 0
    	if(!(parseInt($scope.configuratore.data.id_user)>0)) {
			$location.path( "configuratore-0" );
			$location.replace(); // e cancello il precedente elemento nell'history, impedendo all'utente di tornare qui
    	}
    	
    	$scope.submit = function() {
    		// final redirect to download
			$location.path( "download" );
    	}
	}
	app.controller('Configuratore3Controller', ['$scope','$location','Configuratore', Configuratore3Controller]);
	
	
	// CONFIGURATORE 4 CONTROLLER
	var Configuratore4Controller = function($scope,$location,Configuratore) {
    	// data
    	$scope.configuratore = Configuratore.data;

    	// PREVENT DIRECT ACCESS TO THIS CONTROLLER
    	// se non ho un utente, torno a controller 0
    	if(!(parseInt($scope.configuratore.id_user)>0)) {
			$location.path( "configuratore-0" );
			$location.replace(); // e cancello il precedente elemento nell'history, impedendo all'utente di tornare qui
    	}
    	
    	// how to force download?
	}
	app.controller('Configuratore4Controller', ['$scope','$location','Configuratore', Configuratore4Controller]);
	

	// CONFIGURATORE: ROUTING
	app.config(function($routeProvider,$controllerProvider) {
		
		$controllerProvider.allowGlobals();
		
		$routeProvider.when("/configuratore-0", angularAMD.route({
			// CONFIGURATORE 0
			templateUrl : base_url + 'configuratore-component/configuratore-0',
			controller : Configuratore0Controller,
			// controllerUrl : theme_url + 'src/js/controller_configuratore-0.js',
			animation: 'animation-fade'
		})).when("/configuratore-1", angularAMD.route({
			// CONFIGURATORE 1
			templateUrl : base_url + 'configuratore-component/configuratore-1',
			controller : Configuratore1Controller,
			// controllerUrl : theme_url + 'src/js/controller_configuratore-1.js',
			animation: 'animation-fade'
		})).when("/configuratore-2", angularAMD.route({
			// CONFIGURATORE 2
			templateUrl : base_url + 'configuratore-component/configuratore-2',
			controller : Configuratore2Controller,
			// controllerUrl : theme_url + 'src/js/controller_configuratore-2.js',
			animation: 'animation-fade'
		})).when("/configuratore-3", angularAMD.route({
			// CONFIGURATORE 3
			templateUrl : base_url + 'configuratore-component/configuratore-3',
			controller : Configuratore3Controller,
			// controllerUrl : theme_url + 'src/js/controller_configuratore-3.js',
			animation: 'animation-fade'
		})).when("/download", angularAMD.route({
			// DOWNLOAD
			templateUrl : base_url + 'download',
			controller : Configuratore4Controller,
			// controllerUrl : theme_url + 'src/js/controller_configuratore-4.js',
			animation: 'animation-fade'
		})).otherwise({
			redirectTo : "/configuratore-0"
		});
	});
	

	// MAPPA
	app.directive('mappa', function($timeout) {

		return {
			restrict : 'E',
			transclude : true,
			scope : {id : "="},
			templateUrl: function(tElement, tAttrs) {
			  return base_url + 'mappa/' + tAttrs.id;
			},
			link: function postLink(elemen, attrs, tranclude) {

				// solo dopo dom ok
				$timeout(function() {
					
					// SNAP.SVG MAP
					var s = Snap("#italia");
					if(s) {
						var p = s.selectAll('.el:not(.active)');
						p.forEach(function(e,i) {
							e.attr({'fill':'#e0e0e0','stroke': '#fff','strokeWidth': 3});					// init
							e.mouseover(function() {e.animate({fill:'#00529C'},200,mina.easeinout); });		// mouse enter
							e.mouseout(function() {e.animate({fill:'#e0e0e0'},200,mina.easeoutout); });		// mouse out
						});
						var pactive = s.selectAll('.active');
						pactive.forEach(function(e,i) {
							e.attr({'fill':'#00529C','stroke': '#fff','strokeWidth': 1});					// init
						}); // if s
					} // snap
					
				}); // timeout
			} // link
		};
	}).controller('MappaController', ['$scope',
	function($scope) {

	}]); 
	
	// angularAMD.bootstrap(document, ['webapp']);
	return angularAMD.bootstrap(app);
	// return app;

});
