// ie lte9 support with html5shiv and respond.js
require(['jquery'], function($) {
	if ($('html').hasClass('lte10')) {
		require(['html5shiv','respond'], function() {
			// it's ie lte9	
			alert('its ie lte9');
		});	
	};
});
	
// 'css!src/bower_components/bootstrap/dist/css/bootstrap.min','css!dst/css/base',
require(['app','jquery','bootstrap'], function(app,$) {

	// run application
	
	/**
	 * LOADER NAVBAR
	 */

	// navloader
	$('#navigation').closest('.container-fluid').append('<div id="navloader" class="hidden-xs hidden-sm visible-md visible-lg" />');
	
	/**
	 * HOME: PROGETTI
	 */
	
	// progetti animazione
	$('.box_progetto').on({
		mouseenter: function(e) {
			$(this).addClass('over');
		},
		mouseleave: function(e) {
			$(this).removeClass('over');
		}
	});
	
	// progetti click
	$('.box_progetto')
	.each(function(i){
		// html 5: ricavo il link e wrappo l'elemento con un a href
		var href = $(this).find('a.progetto_url').attr('href');
		$(this).wrap('<a href="'+href+'" />');
	})
	.on({
		// fallback clicco
		click: function() {
			document.location = $(this).find('a.progetto_url').attr('href');
		}
	});

});

// domready scripts: ! stands for run after onload
require(['domReady','masonry','imagelightbox','bootstrap-select','bootstrap-tabdrop','_offcanvas','_retina'], function(domReady,Masonry) {

	// Retina non gestisce resize: TODO
	domReady(function() {
		
		// MASONRY (gallery thumb)
		var elem = document.querySelector('.row-thumb');
		if(elem) {
			var msnry = new Masonry( elem, {
			  // options
			  itemSelector: '.col-thumb',
			});
		}
		
		// selectpicket
	 	$('.selectpicker').selectpicker();

	 	// tabs
		$('[role=tabpanel] .nav-tabs li:first,  [role=tabpanel] .tab-pane:first').addClass('active');
		$('.nav-pills.tabdrop, .nav-tabs.tabdrop').each(function(){
			$this = $(this);
			
			$this.tabdrop({
				text:$this.attr('rel')
			});
		});
		
		// lightbox
		require(['imagelightbox'],function(){
			var selectorF = 'a[data-imagelightbox="f"]';
			var instanceF = $( selectorF ).imageLightbox(
			{
			    allowedTypes:   'png|jpg|jpeg',    // string;
			    animationSpeed: 250,                    // integer;
			    preloadNext:    true,                   // bool;            silently preload the next image
			    enableKeyboard: true,                   // bool;            enable keyboard shortcuts (arrows Left/Right and Esc)
			    quitOnEnd:      false,                  // bool;            quit after viewing the last image
			    quitOnImgClick: false,                  // bool;            quit when the viewed image is clicked
			    quitOnDocClick: true,                   // bool;            quit when anything but the viewed image is clicked
			    quitOnEscKey:   true,                   // bool;            quit when Esc key is pressed
				onStart:		function() { overlayOn();  },
				onEnd:			function() { overlayOff(); activityIndicatorOff(); },
				onLoadStart: 	function() { activityIndicatorOn(); },
				onLoadEnd:	 	function() { activityIndicatorOff(); }
			});
		});
		
		// tooltip
		$('[data-toggle="tooltip"]').tooltip();
		
		resize_icons();
		$(window).resize(function(){
			resize_icons();
		});

	});

});

function resize_icons() {
		// ridimensiono larghezza icone
		$('#box_prodotti').find('li a, li a span.icon').css({
			fontSize:'1em'
		});
		var $box_prodotti = $('#box_prodotti').closest('[class^=col]');
		var box_prodotti_width = $box_prodotti.width() - parseInt($box_prodotti.css('paddingRight')) + parseInt($box_prodotti.css('paddingLeft'));
		var box_prodotti_height = $('#box_prodotti').height();
		var box_prodotti_title_width = parseInt($box_prodotti.find('h1').width());
		var box_prodotto_els_lenght = $box_prodotti.find('li').length;
		var box_prodotto_size = parseInt((box_prodotti_width - (box_prodotto_els_lenght*10) - box_prodotti_title_width) / box_prodotto_els_lenght) * 1.25;
		$box_prodotti.find('li').css({
			width: box_prodotto_size + 'px',
			height: box_prodotto_size + 'px',
			margin: parseInt((box_prodotti_height-box_prodotto_size)/2) + 'px 10px 0 0',
			fontSize: box_prodotto_size + 'px'
		});
}

function bootstrap_equalizer() {
  $(".equalizer").each(function() {
    var heights = $(this).find(".equalizer_watch").map(function() {
      return $(this).height();
    }).get(),

    maxHeight = Math.max.apply(null, heights);

    $(".equalizer_watch").height(maxHeight);
  });
}

			// ACTIVITY INDICATOR

		var activityIndicatorOn = function()
			{
				$( '<div id="imagelightbox-loading"><div></div></div>' ).appendTo( 'body' );
			},
			activityIndicatorOff = function()
			{
				$( '#imagelightbox-loading' ).remove();
			},


			// OVERLAY

			overlayOn = function()
			{
				$( '<div id="imagelightbox-overlay"></div>' ).appendTo( 'body' );
			},
			overlayOff = function()
			{
				$( '#imagelightbox-overlay' ).remove();
			},


			// CLOSE BUTTON

			closeButtonOn = function( instance )
			{
				$( '<button type="button" id="imagelightbox-close" title="Close"></button>' ).appendTo( 'body' ).on( 'click touchend', function(){ $( this ).remove(); instance.quitImageLightbox(); return false; });
			},
			closeButtonOff = function()
			{
				$( '#imagelightbox-close' ).remove();
			},


			// CAPTION

			captionOn = function()
			{
				var description = $( 'a[href="' + $( '#imagelightbox' ).attr( 'src' ) + '"] img' ).attr( 'alt' );
				if( description.length > 0 )
					$( '<div id="imagelightbox-caption">' + description + '</div>' ).appendTo( 'body' );
			},
			captionOff = function()
			{
				$( '#imagelightbox-caption' ).remove();
			},


			// NAVIGATION

			navigationOn = function( instance, selector )
			{
				var images = $( selector );
				if( images.length )
				{
					var nav = $( '<div id="imagelightbox-nav"></div>' );
					for( var i = 0; i < images.length; i++ )
						nav.append( '<button type="button"></button>' );

					nav.appendTo( 'body' );
					nav.on( 'click touchend', function(){ return false; });

					var navItems = nav.find( 'button' );
					navItems.on( 'click touchend', function()
					{
						var $this = $( this );
						if( images.eq( $this.index() ).attr( 'href' ) != $( '#imagelightbox' ).attr( 'src' ) )
							instance.switchImageLightbox( $this.index() );

						navItems.removeClass( 'active' );
						navItems.eq( $this.index() ).addClass( 'active' );

						return false;
					})
					.on( 'touchend', function(){ return false; });
				}
			},
			navigationUpdate = function( selector )
			{
				var items = $( '#imagelightbox-nav button' );
				items.removeClass( 'active' );
				items.eq( $( selector ).filter( '[href="' + $( '#imagelightbox' ).attr( 'src' ) + '"]' ).index( selector ) ).addClass( 'active' );
			},
			navigationOff = function()
			{
				$( '#imagelightbox-nav' ).remove();
			},


			// ARROWS

			arrowsOn = function( instance, selector )
			{
				var $arrows = $( '<button type="button" class="imagelightbox-arrow imagelightbox-arrow-left"></button><button type="button" class="imagelightbox-arrow imagelightbox-arrow-right"></button>' );

				$arrows.appendTo( 'body' );

				$arrows.on( 'click touchend', function( e )
				{
					e.preventDefault();

					var $this	= $( this ),
						$target	= $( selector + '[href="' + $( '#imagelightbox' ).attr( 'src' ) + '"]' ),
						index	= $target.index( selector );

					if( $this.hasClass( 'imagelightbox-arrow-left' ) )
					{
						index = index - 1;
						if( !$( selector ).eq( index ).length )
							index = $( selector ).length;
					}
					else
					{
						index = index + 1;
						if( !$( selector ).eq( index ).length )
							index = 0;
					}

					instance.switchImageLightbox( index );
					return false;
				});
			},
			arrowsOff = function()
			{
				$( '.imagelightbox-arrow' ).remove();
			};