<?php
	$ci =& get_instance();
	
	$nome_prodotto = strtolower('<ion:page:name />');
	
	$ci->db->select("regione_name,$nome_prodotto");
	$ci->db->where($nome_prodotto . ' >','0');
	$result= $ci->db->get('module_province_prodotti');
	$data = $result->result_array();

	foreach($data as $regione) {
		$regione_name = strtolower($regione['regione_name']);
		if(isset($regioni[$regione_name]))
			$regioni[$regione_name] += $regione[$nome_prodotto];
		else
			$regioni[$regione_name] = $regione[$nome_prodotto];
	}
	
	// riordino by key
	ksort($regioni);
	
?>



<article role="tabpanel" >
	<header class="sr-only">
		<h1>I nostri prodotti per regione</h1>
	</header>

	<ion:page>
	
		<ion:element:citta>
			<ion:items>
				<!-- estraggo citta per provincia -->
				<?php $citta['<ion:regione:value />']['<ion:provincia:index />']['provincia'] = '<ion:provincia:value />'; ?>
				<?php $citta['<ion:regione:value />']['<ion:provincia:index />']['citta'] = '<ion:citta:value />'; ?>
				<?php $citta['<ion:regione:value />']['<ion:provincia:index />']['via'] = '<ion:via:value />'; ?>
				<?php $citta['<ion:regione:value />']['<ion:provincia:index />']['prodotto'] = '<ion:prodotto:value />'; ?>
				<?php $citta['<ion:regione:value />']['<ion:provincia:index />']['dimensione'] = '<ion:dimensione:value />'; ?>
				<?php $citta['<ion:regione:value />']['<ion:provincia:index />']['posizione'] = '<ion:posizione:value />'; ?>
				<?php $citta['<ion:regione:value />']['<ion:provincia:index />']['base'] = '<ion:base:value />'; ?>
				<?php $citta['<ion:regione:value />']['<ion:provincia:index />']['altezza'] = '<ion:altezza:value />'; ?>
				<?php $citta['<ion:regione:value />']['<ion:provincia:index />']['scheda'] = '<ion:scheda:medias:media:src type="file" />'; ?>
			</ion:items>
		</ion:element:citta>
		

		<div class="tab-pane fade in table-responsive"> 
			<table class="table">
				<thead>
					<tr>
						<th class="col-xs-10">
							REGIONE
						</th>
						<th class="col-xs-2 text-center">
							INSTALLAZIONI
						</th>
					</tr>
				</thead>
				
				<tbody>
					<?php foreach($regioni as $regione => $installazioni) : ?>
							<tr>
								<td class="icon col-xs-10">
									<a href="<ion:base_url />spazi-pubblicitari-arredo-urbano/regioni/<?php echo $regione; ?>" style="display:block;">
										<?php echo $regione; ?>
									</a>
									
									<?php if(isset($citta[$regione])) : ?>
										
										<span style="display:block;height:7px;"></span>
										
										<?php foreach($citta[$regione] as $reg => $scheda) : ?>
											<a href="<?php echo $scheda['scheda']; ?>" style="text-transform:none" rel="external" target="_blank" data-toggle="tooltip" data-placement="left" title="Download">
												<table class="table table-condensed table-hover" style="margin:0">
													<tr>
														<td style="border:none;padding-left:0;color:#333;vertical-align:top;" class="col-xs-3">
															<strong style="color:#333;"><?php echo $scheda['citta']; ?></strong>
														</td>
														<td style="border:none;text-transform:none;color:#333;vertical-align:top;" class="col-xs-4">
															
															<?php if(!empty($scheda['posizione'])) : ?>
																<span data-toggle="tooltip" data-placement="bottom" title="<?php echo $scheda['posizione']; ?>" style="border-bottom:1px dotted #ddd;">
																	<?php echo $scheda['via']; ?>
																</span>
															<?php else : ?>
																<?php echo $scheda['via']; ?>	
															<?php endif; ?>
	
														</td>
														<td style="border:none;color:#333;vertical-align:top;" class="col-xs-3">
															<?php if(!empty($scheda['prodotto'])) : ?>
																<?php echo $scheda['prodotto']; ?>
															<?php endif; ?>
														</td>
														<td style="border:none;text-transform:none;color:#333;vertical-align:top;" class="col-xs-2">
															<?php if(!empty($scheda['base']) && !empty($scheda['altezza'])) : ?>
																<span data-toggle="tooltip" data-placement="bottom" title="<?php echo $scheda['base']; ?> x <?php echo $scheda['altezza']; ?>" style="border-bottom:1px dotted #ddd;">
																	<?php echo $scheda['dimensione']; ?> mq
																</span>
																
															<?php else : ?>
																<?php echo $scheda['dimensione']; ?> mq	
															<?php endif; ?>
														</td>
													</tr>
												</table>
											</a>
										<?php endforeach; ?>
									<?php endif; ?>
									
								</td>
								<td class="col-xs-2 text-center">
									<span class="badge"><?php echo $installazioni; ?></span>
								</td>
							</tr>
							
					<?php endforeach; ?>
					
				</tbody>
			</table>
		</div>
	</ion:page>
</article>
